set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9331536';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3231',
      '11202021',
      '11403241',
      '31030313',
      '31232421',
      '33010041',
      '10401244',
      NULL,
      '44343123',
      '43233213',
      '12413014',
      '30141430',
      '10433312',
      '40021332',
      NULL,
      NULL,
      '22432430',
      '22142043',
      NULL,
      '02241440',
      '13222203',
      '12143411',
      '40231010',
      NULL,
      '24010302',
      '44144032',
      '42124324',
      '02011324',
      '23103110',
      '30410002',
      '42222413',
      NULL,
      '01003004',
      '41213113',
      NULL,
      '34113044',
      '34320123',
      NULL,
      NULL,
      '22324003',
      '20301323',
      '31432344',
      '42111343',
      '10431304',
      NULL,
      '042',
      '32',
      17,
      4,
      '2344040',
      0,
      1,
      2,
      NULL,
      '231402',
      1.223108,
      ' 6- 4-1990',
      ' 7-17-1991',
      20,
      77,
      9.193849,
      0,
      1,
      6.939605,
      72.205544,
      3,
      3.138036,
      15.689883,
      2.192026,
      0.379364,
      32.768650,
      NULL,
      6.386729,
      3.920049,
      7.991046,
      11,
      1.929722,
      17.466056,
      NULL,
      5.965256,
      120,
      NULL,
      1,
      NULL,
      3,
      8.474552,
      50,
      20,
      115.245815,
      ' 4- 2-1981',
      29.616602,
      15.304092,
      22,
      19.377024,
      32.749287,
      NULL,
      '11- 0-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      43,
      11,
      32.934903,
      NULL,
      29,
      3,
      ' 0-20-1996',
      1,
      1,
      47.796561,
      5,
      0.679532,
      NULL,
      1.267308,
      5,
      3,
      NULL,
      NULL,
      NULL,
      ' 7- 9-1993',
      18,
      55,
      34,
      15.142394,
      11.888675,
      33.298511,
      30,
      NULL,
      68,
      22.749801,
      39,
      30.148300,
      ' 3- 9-1992',
      12.783436,
      NULL,
      8,
      NULL,
      NULL,
      1,
      3.514182,
      ' 7-18-2003',
      27.744587,
      12.235277,
      ' 2-20-1992',
      NULL,
      11,
      15.102234,
      0.989054,
      11.370989,
      4.757694,
      NULL,
      NULL,
      NULL,
      81.586407,
      9.827138,
      NULL,
      1.078446,
      NULL,
      0.712136,
      4,
      3,
      NULL,
      '11- 3-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      ' 6-16-1988',
      29.309509,
      NULL,
      5.670958,
      1.811564,
      '11- 3-1981',
      6,
      7,
      ' 7-10-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      ' 7- 9-1986',
      NULL,
      24,
      NULL,
      ' 3-25-1989',
      NULL,
      2.879242,
      ' 4- 5-1991',
      NULL,
      68.724809,
      17,
      24,
      ' 9-26-1995',
      13,
      0,
      75.105588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


