set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9331536';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4423',
      '02424332',
      NULL,
      '00023031',
      NULL,
      NULL,
      '12320333',
      '13121412',
      '20130143',
      '12021141',
      '30112010',
      NULL,
      '31202113',
      '22432121',
      NULL,
      '31101040',
      '04430020',
      '01340333',
      '02223003',
      '33324033',
      '31024334',
      '30104332',
      NULL,
      '12102012',
      '30201204',
      '42100314',
      '03133243',
      '22143233',
      NULL,
      '21110103',
      '03230310',
      '04310313',
      NULL,
      '24242221',
      '33124310',
      '44230303',
      NULL,
      '01432142',
      '42424230',
      '14020302',
      '14104130',
      '03141241',
      '34131113',
      '32323143',
      NULL,
      '330',
      NULL,
      13,
      3.459800,
      NULL,
      2,
      NULL,
      3,
      NULL,
      '243141',
      3.679154,
      '10- 8-2003',
      ' 5-12-1995',
      87,
      42,
      0.785326,
      3,
      NULL,
      11.983618,
      42,
      13,
      3.992729,
      15.150388,
      NULL,
      NULL,
      2.847889,
      5.447058,
      NULL,
      NULL,
      10.544861,
      2.602248,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      17.097148,
      0.230320,
      38,
      NULL,
      63.150895,
      146.373482,
      22,
      NULL,
      ' 3-28-1999',
      38,
      15,
      15.927201,
      8.178730,
      76,
      161.399498,
      ' 3-18-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27,
      29,
      19.499985,
      NULL,
      8,
      4,
      ' 8-29-1994',
      1,
      NULL,
      NULL,
      1,
      1.880883,
      44,
      0,
      1.005612,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 0-1979',
      69,
      28.618046,
      13.429284,
      79.565438,
      17,
      53.729740,
      NULL,
      49.441802,
      54.261224,
      NULL,
      28.362409,
      54,
      '11-15-1988',
      NULL,
      1,
      0.203541,
      3.335671,
      18,
      2,
      3,
      ' 6-10-1984',
      3,
      18,
      NULL,
      NULL,
      7,
      13,
      3,
      1,
      1,
      1.617823,
      11.309932,
      1.833136,
      41.442100,
      NULL,
      8,
      17,
      18,
      3.049152,
      2,
      5,
      0,
      ' 9-14-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      96.256456,
      0,
      ' 2- 1-1991',
      NULL,
      NULL,
      NULL,
      46.609668,
      '11- 8-2003',
      38,
      ' 3-21-1993',
      7,
      10,
      ' 3- 1-1989',
      59.876237,
      27,
      ' 2-25-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      21.103422,
      ' 5-11-1977',
      27.714843,
      26,
      NULL,
      ' 0- 7-1975',
      0,
      102.048603,
      NULL,
      3.104899,
      69.228357,
      4.549044,
      17.584711,
      ' 5-23-1982',
      NULL,
      0,
      96,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


