set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9331536';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      '0',
      '2',
      '3',
      NULL,
      NULL,
      '4',
      '0',
      '0',
      '0',
      '1',
      '3',
      '4',
      '2',
      '1',
      '2',
      '3',
      '4',
      '4',
      NULL,
      '1',
      '1',
      '0',
      '',
      '1',
      '',
      '3',
      '0',
      NULL,
      '2',
      '4',
      '',
      '',
      '4',
      '0',
      '4',
      '3',
      '1',
      '3',
      '2',
      '4',
      '4',
      '4',
      '4',
      '332',
      '04143404',
      NULL,
      46.224418,
      '2311304',
      0,
      NULL,
      2,
      NULL,
      '424114',
      3.243646,
      '10-16-1975',
      ' 5-24-1985',
      64.260793,
      37.372998,
      NULL,
      4,
      4,
      12.394388,
      16,
      NULL,
      2.821400,
      7,
      10,
      6.560415,
      22.511557,
      9.326633,
      3,
      17.886665,
      13,
      11,
      7,
      2,
      NULL,
      7,
      77.634665,
      16.362056,
      0.437943,
      65,
      136.797945,
      2,
      54.767701,
      39.575471,
      132.597236,
      '11- 8-1992',
      21,
      NULL,
      NULL,
      24.859939,
      13,
      199.369317,
      ' 2-19-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31.599484,
      NULL,
      5.236293,
      1.161291,
      9,
      NULL,
      0.928772,
      0.497400,
      56,
      NULL,
      NULL,
      27,
      NULL,
      0.742238,
      21.148661,
      NULL,
      NULL,
      NULL,
      ' 6- 2-1983',
      21,
      37.995324,
      17.192414,
      51,
      39,
      0,
      62,
      27,
      18.831558,
      25.269571,
      18.821322,
      NULL,
      ' 8-29-1995',
      1,
      6,
      6.152393,
      NULL,
      34,
      6.435394,
      2.530432,
      ' 5- 0-2003',
      14.783759,
      5,
      ' 2-11-1986',
      6,
      0,
      4.644106,
      9,
      15,
      NULL,
      NULL,
      1.504394,
      2.701243,
      55,
      0.585640,
      0.348740,
      0.728899,
      NULL,
      4.570719,
      0,
      2.207426,
      NULL,
      ' 1- 4-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46.057046,
      '10-20-1990',
      12.422698,
      NULL,
      0.236793,
      11.629655,
      ' 3-20-1997',
      17,
      38.584902,
      ' 8-21-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      16.558221,
      ' 8- 8-2000',
      30,
      19,
      5.567659,
      ' 5-27-2003',
      NULL,
      45.886907,
      ' 2- 9-1980',
      7,
      66.706166,
      NULL,
      37,
      ' 7-20-2001',
      NULL,
      1,
      125.633710,
      ' 3-28-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


