set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9222256';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4310',
      '42413110',
      '34134421',
      '44223124',
      NULL,
      '34013314',
      NULL,
      '04403103',
      '11410324',
      NULL,
      '10320021',
      '02204231',
      '11031022',
      '33320030',
      NULL,
      '00430322',
      '42030230',
      '13131420',
      NULL,
      NULL,
      '10312213',
      '21442303',
      '13204012',
      '22121124',
      '02202443',
      '31044034',
      '11423221',
      '12402033',
      '03143301',
      '24114040',
      NULL,
      '30220221',
      '10434132',
      '40201023',
      '20011141',
      '30144411',
      '21240220',
      '41244223',
      '23101443',
      '04011342',
      '22103344',
      '20131012',
      '24412331',
      NULL,
      '04403404',
      '344',
      '14',
      NULL,
      NULL,
      '0102344',
      3.819434,
      0.010378,
      3,
      NULL,
      '324142',
      3.451713,
      ' 8-16-1975',
      ' 9- 8-2000',
      235,
      76.451156,
      50,
      11.666528,
      12.762134,
      6,
      8,
      16.364795,
      NULL,
      2.613261,
      28,
      20.165132,
      47,
      NULL,
      29,
      7.535147,
      9.018024,
      2.762877,
      75,
      2.699825,
      2.689112,
      23,
      NULL,
      5,
      0.100305,
      NULL,
      47,
      3,
      93,
      196,
      129.356023,
      ' 1-11-1980',
      63.650858,
      36,
      NULL,
      26,
      114,
      NULL,
      ' 5-28-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.153365,
      19,
      1.087895,
      7,
      NULL,
      3,
      ' 7-12-1991',
      0.758333,
      1.365417,
      149,
      0,
      0.724675,
      99.823800,
      NULL,
      0.152902,
      43.617002,
      NULL,
      NULL,
      NULL,
      ' 1-10-1975',
      31.932149,
      102,
      95.464395,
      NULL,
      87.166551,
      15,
      NULL,
      59,
      39,
      44.077697,
      90,
      NULL,
      ' 3-26-1995',
      15,
      24.051458,
      11,
      NULL,
      60,
      46.016633,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      93.392507,
      3,
      ' 8-21-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-14-1995',
      35,
      ' 5- 2-1978',
      15.963143,
      NULL,
      ' 2-21-1984',
      55,
      11,
      '10- 6-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      ' 4-22-2000',
      72,
      42,
      25,
      ' 3-10-1985',
      NULL,
      4.424146,
      ' 1-28-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


