set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9516195';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      '1',
      NULL,
      NULL,
      '4',
      '0',
      '2',
      '3',
      NULL,
      '4',
      NULL,
      '2',
      '4',
      '3',
      '2',
      '2',
      NULL,
      '3',
      NULL,
      '3',
      '3',
      '3',
      '3',
      '',
      '2',
      '',
      NULL,
      '3',
      NULL,
      '0',
      '1',
      NULL,
      '',
      '1',
      NULL,
      NULL,
      '2',
      '0',
      '2',
      '3',
      '1',
      '0',
      '2',
      '2',
      '102',
      '40304222',
      NULL,
      47.028991,
      '3003234',
      0.502915,
      0.015579,
      0,
      NULL,
      '123443',
      4.937857,
      ' 0-15-2000',
      ' 5-13-1991',
      40.038901,
      39,
      31.923976,
      13,
      NULL,
      0.458198,
      99.405580,
      14.191647,
      19.428656,
      13,
      7,
      15,
      2.454853,
      12.835310,
      NULL,
      10.080065,
      7.999472,
      NULL,
      NULL,
      13,
      35.632575,
      14,
      NULL,
      18,
      NULL,
      104,
      124.351044,
      NULL,
      120.924029,
      115.432068,
      129.730083,
      ' 1-22-1992',
      60.385623,
      30.901439,
      18.532319,
      14.425501,
      NULL,
      NULL,
      ' 1-22-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      77.751709,
      18,
      2,
      0.085273,
      11,
      NULL,
      ' 4- 8-1979',
      NULL,
      0,
      81.754006,
      1.208599,
      0,
      38,
      1.378320,
      1,
      73,
      NULL,
      NULL,
      NULL,
      ' 0-18-1977',
      62.774918,
      NULL,
      46.912813,
      NULL,
      55,
      71.622150,
      30,
      4.381179,
      59.311425,
      73.086529,
      46.825149,
      76,
      NULL,
      5,
      27.683820,
      5.086427,
      45,
      62,
      24,
      0.775467,
      NULL,
      6,
      25,
      NULL,
      5,
      NULL,
      11.184562,
      1,
      21.586371,
      5,
      1,
      18.928948,
      1.893658,
      79,
      0,
      1,
      12,
      14.997453,
      0,
      0,
      0.852899,
      0.895412,
      ' 9- 3-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      116,
      3,
      ' 4-12-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      '11-15-1990',
      0.411948,
      13,
      ' 3-17-1986',
      74,
      60,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      8,
      ' 2-28-1975',
      43,
      27,
      12.750356,
      ' 1-16-2000',
      NULL,
      18.135885,
      ' 4-23-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


