set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8933321';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3212',
      '01004112',
      '23342413',
      '44014042',
      '13341114',
      '00224231',
      NULL,
      '00101140',
      '14104414',
      '33220002',
      NULL,
      '02201024',
      '10033032',
      '00044102',
      '11434142',
      '23343013',
      '12433221',
      '21132231',
      '42331210',
      '33001412',
      '43134231',
      '22110000',
      '20131340',
      '13332034',
      NULL,
      '14010222',
      '40022224',
      '40422342',
      '14442341',
      '04233314',
      '14200030',
      '23300414',
      '43412131',
      NULL,
      '31034231',
      '04342141',
      '22304304',
      '44413243',
      NULL,
      '30010030',
      '41212032',
      '14243201',
      NULL,
      '01243431',
      '42224220',
      '224',
      '40',
      39,
      19,
      NULL,
      0.950300,
      1.793525,
      0,
      NULL,
      '330021',
      1,
      NULL,
      ' 2- 7-1981',
      95.913439,
      8.876194,
      12.544046,
      1.963456,
      NULL,
      20,
      75.976858,
      0,
      22.272636,
      19.369801,
      34.953597,
      23,
      9.569741,
      NULL,
      NULL,
      11.841682,
      NULL,
      13.809846,
      NULL,
      29,
      57.300563,
      20.038818,
      72,
      NULL,
      0,
      NULL,
      65,
      83,
      123,
      NULL,
      NULL,
      ' 3-14-1976',
      44,
      20,
      21.661524,
      NULL,
      191.225005,
      216.074635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      61.243418,
      19,
      NULL,
      0.831027,
      8.384931,
      NULL,
      ' 2-21-1992',
      2.071010,
      0,
      44,
      1,
      NULL,
      96,
      3,
      1,
      24.004365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      84.249387,
      102,
      22.489881,
      NULL,
      33,
      57.601227,
      62,
      49,
      75,
      16,
      65,
      ' 5- 3-1990',
      12,
      25.989092,
      23.981978,
      87.693331,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      12.376022,
      ' 2-22-1991',
      8.712669,
      14,
      20.748464,
      10.770150,
      21,
      NULL,
      1.894811,
      3,
      1,
      23.507741,
      10.654071,
      NULL,
      20.773928,
      NULL,
      2,
      6.206496,
      0,
      1,
      ' 2-20-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      126,
      1.506271,
      ' 8-29-1993',
      NULL,
      NULL,
      NULL,
      35.509593,
      ' 7- 1-1977',
      14,
      ' 2-18-2002',
      20.163319,
      17,
      ' 3-29-2001',
      26,
      19.406109,
      ' 8- 6-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      24,
      ' 9-26-1998',
      52,
      NULL,
      67,
      ' 8- 1-1998',
      1.079111,
      10,
      ' 5-27-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


