set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7828666';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4304',
      NULL,
      '03122343',
      '00430112',
      '43210300',
      '42121042',
      '24221031',
      '30002200',
      '12442301',
      '11334224',
      '10304443',
      '43133122',
      '20230020',
      '30033040',
      '32010134',
      NULL,
      '23204213',
      NULL,
      '40034130',
      '11043320',
      '22342122',
      '00032141',
      '34311424',
      '33441224',
      '22324311',
      '13224401',
      '10031443',
      '14433244',
      '20421014',
      NULL,
      '02140223',
      '11323143',
      '30144043',
      '34221423',
      '03442244',
      NULL,
      '04311101',
      '00230424',
      '33414330',
      '34012103',
      NULL,
      '00122320',
      '23314110',
      '40342323',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '1321000',
      3.218431,
      0.848855,
      1,
      NULL,
      '121020',
      3.309943,
      ' 9-24-1995',
      ' 1- 0-1986',
      0.635319,
      NULL,
      11.089130,
      NULL,
      22.849348,
      0,
      NULL,
      NULL,
      10,
      10,
      33.876675,
      NULL,
      19,
      11.898154,
      11.481594,
      12.197318,
      NULL,
      14,
      21,
      0.887431,
      NULL,
      11.626297,
      NULL,
      5,
      NULL,
      53.082859,
      2,
      13,
      NULL,
      183.245327,
      179.986738,
      ' 9-25-1997',
      20,
      17.281945,
      18,
      2,
      66,
      157.139698,
      ' 8- 0-2001',
      3.445949,
      5.020182,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.590290,
      1.990856,
      4.441317,
      NULL,
      1.231397,
      0.503510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-24-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 6-1974',
      74,
      33.267810,
      25,
      NULL,
      74.336002,
      NULL,
      74.315544,
      19.010309,
      4.422486,
      30,
      40.239766,
      17.285636,
      ' 5-18-1994',
      18.251882,
      4,
      2.208769,
      48,
      NULL,
      46,
      0.316908,
      ' 3- 4-1979',
      1.647005,
      NULL,
      ' 0-14-1999',
      9,
      2,
      5.007100,
      8,
      9,
      7,
      NULL,
      9,
      NULL,
      39,
      1.945250,
      0.883822,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 8-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      57,
      31,
      6,
      ' 3-11-1982',
      1,
      70,
      ' 7-23-2002',
      1.173865,
      19.712627,
      18.162512,
      NULL,
      ' 6- 5-1986',
      32.951317,
      1.177826,
      3,
      ' 3- 7-1975',
      NULL,
      NULL,
      NULL,
      79.922864,
      53.950538,
      15.431926,
      16.070419,
      NULL,
      NULL,
      57,
      43,
      31,
      52.075583,
      0.641219,
      NULL,
      1,
      NULL,
      36.887442,
      1.104197,
      1,
      61.517303,
      0,
      NULL,
      NULL,
      1.693331,
      1.131205,
      140,
      7.807962,
      9.794523,
      88,
      0,
      87.872129,
      1.893450,
      0.096870,
      1.003059,
      1.306285,
      3.478889,
      NULL,
      43.033002,
      80,
      NULL,
      NULL,
      14,
      NULL,
      0.331937,
      NULL,
      17,
      0,
      NULL,
      1.279047,
      NULL,
      NULL,
      87.023381,
      0.394236,
      24,
      NULL,
      NULL,
      26,
      25.465550,
      NULL,
      3.381786,
      83,
      NULL,
      19.581354,
      NULL,
      7,
      3.468724,
      0,
      0.324027,
      1,
      1,
      NULL,
      0,
      26.549239,
      ' 5-19-1979',
      '10- 9-1991',
      ' 6-25-1981',
      '11-10-2002',
      ' 1-13-1983',
      ' 2- 2-2001',
      ' 9-28-1980',
      NULL);
commit;
end;
/


