set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6111038';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2014',
      '03402021',
      '33310023',
      NULL,
      '23042021',
      '41120322',
      '02100304',
      NULL,
      '14330004',
      NULL,
      '34103412',
      '03430231',
      NULL,
      '32123430',
      '33121010',
      '20334004',
      '11312210',
      '30411413',
      NULL,
      '43230141',
      '30434310',
      '11422142',
      '41121301',
      NULL,
      '10014144',
      NULL,
      '02003143',
      '40311001',
      '01112043',
      NULL,
      '43010132',
      NULL,
      '30001013',
      '24421421',
      NULL,
      '14430423',
      '31343323',
      '24034020',
      NULL,
      NULL,
      '04013013',
      '31014443',
      '12214402',
      '43342101',
      '43112213',
      '',
      '',
      NULL,
      NULL,
      NULL,
      1,
      0.683297,
      2,
      NULL,
      NULL,
      3.181904,
      ' 2-19-1995',
      NULL,
      4.470751,
      NULL,
      22,
      6,
      16.329937,
      6.497016,
      64.260078,
      NULL,
      NULL,
      28.695372,
      13.628155,
      NULL,
      1.709423,
      26,
      NULL,
      10.579360,
      0.384607,
      13.703311,
      76,
      NULL,
      NULL,
      11.654769,
      129,
      20,
      NULL,
      125.799484,
      155,
      41.230958,
      NULL,
      NULL,
      37,
      NULL,
      61.649941,
      15,
      NULL,
      27,
      23,
      236.681665,
      ' 2- 0-1981',
      2.994260,
      2,
      1.873121,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.099777,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-29-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      102.249231,
      62.011494,
      18.463715,
      15.026028,
      140,
      30.473897,
      73,
      NULL,
      83.030953,
      30.616305,
      93.767088,
      43.984540,
      ' 8- 8-1992',
      23.771441,
      12.035069,
      NULL,
      93,
      73.940188,
      52,
      NULL,
      ' 5-10-1985',
      0,
      17.089658,
      '10-23-1990',
      10,
      17,
      16.844790,
      27,
      0,
      8.590300,
      NULL,
      NULL,
      NULL,
      NULL,
      1.087978,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-19-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47.115979,
      27,
      1,
      ' 2- 7-1987',
      0,
      79.524841,
      ' 5- 8-2000',
      5.908358,
      8,
      6,
      17,
      '10- 6-1980',
      25.278482,
      1.681583,
      47.421465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.502523,
      0,
      NULL,
      NULL,
      54,
      1.077138,
      11.665881,
      6.559344,
      9.125346,
      7.955931,
      NULL,
      0,
      1,
      10.623471,
      0,
      NULL,
      94,
      2.522033,
      0,
      NULL,
      0.894348,
      NULL,
      NULL,
      NULL,
      3.227200,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      0,
      0.473013,
      0.894015,
      NULL,
      NULL,
      NULL,
      5.947747,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      25.345619,
      12.418894,
      16.113039,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      1,
      1.192785,
      3,
      0,
      0.979846,
      0,
      0,
      NULL,
      ' 0-29-1976',
      ' 4-25-1984',
      NULL,
      ' 7-12-1991',
      NULL,
      NULL,
      ' 2-29-1982',
      NULL);
commit;
end;
/


