set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7108881';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2233',
      NULL,
      NULL,
      '22442321',
      '43400412',
      '41220223',
      '04424333',
      '32142444',
      '32133104',
      NULL,
      '10133241',
      NULL,
      '12231314',
      '01332303',
      NULL,
      '13230003',
      '40334310',
      '03003113',
      '01120213',
      NULL,
      NULL,
      '33432244',
      NULL,
      '03343114',
      '42420032',
      '31222202',
      '12222231',
      '03431043',
      '04030111',
      '41222332',
      '42130024',
      '01133202',
      '31431001',
      NULL,
      '20302401',
      '41443300',
      '34433332',
      NULL,
      NULL,
      '21110333',
      '41231343',
      '11022042',
      NULL,
      '14422103',
      '34430341',
      NULL,
      '12',
      NULL,
      NULL,
      '0014313',
      2.404332,
      NULL,
      0,
      NULL,
      '412340',
      2,
      ' 8-26-1997',
      ' 0-26-2003',
      36.020641,
      NULL,
      NULL,
      0.346393,
      NULL,
      11.753868,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      2,
      NULL,
      0,
      NULL,
      9.636278,
      NULL,
      11.808364,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      1.338857,
      80,
      134.823812,
      44.566682,
      208,
      NULL,
      NULL,
      ' 8-23-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.896886,
      0.700093,
      3,
      2.909373,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      1.325221,
      0.375247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-10-1992',
      NULL,
      2.168890,
      6.354428,
      8,
      3,
      5.737682,
      ' 6-11-1991',
      NULL,
      1,
      15.604852,
      4.638961,
      2.385221,
      11,
      1,
      6,
      55,
      NULL,
      NULL,
      NULL,
      NULL,
      137.913227,
      125,
      111,
      49.335213,
      112.442923,
      20.871154,
      99.376498,
      NULL,
      117.820479,
      55,
      37.399798,
      3.801517,
      NULL,
      17.541368,
      NULL,
      NULL,
      NULL,
      31.176711,
      1,
      1.819441,
      '10- 7-1985',
      10,
      NULL,
      ' 9-15-1980',
      5.900132,
      NULL,
      19.077040,
      NULL,
      NULL,
      NULL,
      1,
      9.738475,
      1,
      4,
      1,
      NULL,
      19.284491,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40.250116,
      NULL,
      10,
      NULL,
      1.259810,
      NULL,
      ' 5-19-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


