set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9716945';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0344',
      '11242032',
      '43304411',
      '11114421',
      NULL,
      '31430224',
      '12020141',
      '20204224',
      '11100033',
      '11000400',
      '22224000',
      '40220032',
      '40241220',
      '14020333',
      '22124302',
      NULL,
      '11033032',
      '21444041',
      NULL,
      '02132020',
      '01423244',
      '22103102',
      '31321411',
      '30332030',
      '12213134',
      '10241220',
      NULL,
      '30420341',
      '21243202',
      '42040022',
      '20033330',
      NULL,
      NULL,
      '23243233',
      '20323403',
      '03233201',
      '41233320',
      NULL,
      '24343112',
      NULL,
      '42200403',
      NULL,
      '03424400',
      NULL,
      '11204424',
      '240',
      '11',
      NULL,
      0,
      NULL,
      NULL,
      0.057355,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-10-1976',
      105,
      4.954149,
      32.502751,
      NULL,
      25,
      16,
      NULL,
      14,
      34,
      NULL,
      NULL,
      16,
      2.960775,
      13,
      0.572195,
      8.735042,
      16.177828,
      13,
      NULL,
      11.852502,
      28,
      12,
      17.488360,
      NULL,
      0,
      109,
      NULL,
      59,
      107.160948,
      197,
      133.053654,
      ' 3-25-1977',
      NULL,
      NULL,
      NULL,
      32.620047,
      185,
      206.445491,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      58,
      22,
      40,
      12,
      0.210285,
      NULL,
      ' 9- 7-1985',
      1.740947,
      0,
      75,
      0,
      0,
      59.841992,
      1.645452,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      ' 3- 3-1995',
      NULL,
      NULL,
      NULL,
      77.473161,
      73,
      21,
      14,
      42,
      11.563612,
      18.185078,
      36.617270,
      36,
      ' 1-21-1981',
      4,
      2.789675,
      27.296042,
      21.130034,
      13,
      118,
      NULL,
      ' 6- 1-1988',
      1,
      2,
      NULL,
      8.776913,
      11.184874,
      7,
      1,
      NULL,
      4,
      0,
      1.029350,
      1,
      63,
      2.652811,
      5,
      7,
      NULL,
      10,
      NULL,
      1,
      1.282184,
      ' 3- 4-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41,
      '11- 1-1996',
      NULL,
      NULL,
      NULL,
      26.611855,
      ' 8-24-1990',
      28,
      ' 0-29-1979',
      NULL,
      3,
      '10-16-2000',
      NULL,
      63.509116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      9,
      ' 8-12-1993',
      4,
      NULL,
      28,
      ' 3-16-1991',
      4,
      211.060168,
      '11-15-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


