set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8328397';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2121',
      '32112434',
      '11004422',
      NULL,
      '00410223',
      NULL,
      '13223324',
      '43121004',
      NULL,
      '04000331',
      '01104324',
      '01303243',
      '42114412',
      '40042040',
      '40332104',
      '33132010',
      NULL,
      NULL,
      NULL,
      '13102023',
      '02040404',
      '43321201',
      '23040211',
      '40204322',
      '02402110',
      NULL,
      '43134410',
      NULL,
      NULL,
      '31212413',
      NULL,
      '34440332',
      '20330422',
      NULL,
      '10032211',
      '04124310',
      '11121413',
      '01344134',
      '12311204',
      '43120432',
      '02200142',
      NULL,
      NULL,
      '01320421',
      '42041210',
      '203',
      '11',
      33.503539,
      NULL,
      '2011300',
      2,
      19,
      1,
      NULL,
      '231200',
      NULL,
      ' 0-17-1998',
      NULL,
      75,
      92,
      1,
      9.992792,
      25,
      8,
      10,
      8.234420,
      11.706627,
      8,
      NULL,
      10.646667,
      35,
      11,
      12.368454,
      2,
      12.442418,
      5.515477,
      NULL,
      3,
      35,
      NULL,
      19,
      NULL,
      1,
      55.229062,
      NULL,
      85,
      53.265431,
      86.544566,
      NULL,
      NULL,
      27.633955,
      9.676037,
      2.540175,
      11,
      90.175581,
      11.116175,
      ' 1- 8-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32.065518,
      9.879212,
      NULL,
      NULL,
      4.779496,
      NULL,
      ' 5- 3-1974',
      0.280365,
      2,
      109,
      NULL,
      2.801843,
      94.098465,
      0.367034,
      1.725536,
      23.852570,
      NULL,
      NULL,
      NULL,
      '10-16-1998',
      59.553431,
      76,
      NULL,
      7,
      23,
      78.947302,
      49,
      NULL,
      55.916764,
      NULL,
      NULL,
      NULL,
      ' 8-28-1985',
      1,
      17.906635,
      9.672670,
      35.755684,
      NULL,
      31.555917,
      NULL,
      ' 3- 7-2003',
      NULL,
      20.101557,
      ' 2- 1-1986',
      3,
      18.945558,
      6.043045,
      16,
      NULL,
      10.367893,
      NULL,
      16,
      0,
      43,
      1.340244,
      4.415458,
      NULL,
      18,
      0,
      2,
      NULL,
      0.574037,
      ' 5-12-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 4-19-1981',
      NULL,
      NULL,
      NULL,
      53,
      '11- 8-2003',
      29.687378,
      ' 3-20-1988',
      8.738405,
      NULL,
      ' 0- 3-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      12.970230,
      ' 7-16-1991',
      18,
      0,
      9,
      ' 1-16-2003',
      5,
      NULL,
      ' 7- 3-2000',
      9,
      71,
      17.748864,
      58.803457,
      NULL,
      NULL,
      0,
      NULL,
      ' 3- 3-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


