set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8825651';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3430',
      NULL,
      '12020344',
      '13414402',
      '31414322',
      '31242130',
      NULL,
      '20021410',
      '12201111',
      '02220101',
      '03422442',
      '32314012',
      '43410024',
      NULL,
      '01330002',
      NULL,
      '22134133',
      '43403440',
      '42410103',
      '40040310',
      '10232214',
      '20033132',
      '32120244',
      NULL,
      NULL,
      '34412332',
      NULL,
      '03420132',
      '44110344',
      '13112310',
      '41020340',
      '12430111',
      NULL,
      '00401444',
      '10422322',
      '42311004',
      '20311342',
      '13134240',
      '00211420',
      '21021111',
      '14400004',
      '21114003',
      '33223331',
      '31241412',
      NULL,
      '201',
      '23',
      NULL,
      NULL,
      '3241033',
      2,
      0,
      NULL,
      NULL,
      '400120',
      4,
      ' 7- 4-2002',
      ' 4-17-2003',
      NULL,
      NULL,
      2.484908,
      2,
      16,
      2,
      43.398270,
      2.991732,
      24.673535,
      1.899097,
      NULL,
      NULL,
      8.517466,
      25.250161,
      NULL,
      NULL,
      4,
      11.505930,
      1,
      4.846041,
      20,
      NULL,
      58,
      1.491753,
      1.582072,
      37.050834,
      122,
      13,
      42,
      33,
      NULL,
      ' 0-23-1982',
      14,
      50,
      19.470473,
      24,
      203,
      148.673650,
      '10-25-1985',
      NULL,
      1,
      1.083039,
      3.469574,
      2.181724,
      2.961911,
      1,
      0,
      NULL,
      0.632930,
      1,
      0.626834,
      0,
      2,
      0.737683,
      1.081749,
      3,
      NULL,
      0,
      0.873169,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-18-1983',
      NULL,
      10,
      3,
      1.233453,
      0,
      NULL,
      '11-14-1984',
      NULL,
      NULL,
      44.875259,
      1,
      NULL,
      71.950505,
      3,
      NULL,
      26,
      0,
      0.502900,
      117,
      ' 2-13-1980',
      49.166712,
      NULL,
      1,
      NULL,
      65,
      NULL,
      NULL,
      25,
      63.245156,
      NULL,
      NULL,
      NULL,
      ' 0- 8-1988',
      8.870019,
      34.903228,
      44,
      56,
      124,
      NULL,
      1.660513,
      ' 6-16-1978',
      14,
      15.414159,
      ' 2-22-1996',
      5.956138,
      8,
      16.765501,
      4.784038,
      24.450475,
      7.600881,
      1,
      9,
      1.458206,
      67,
      1,
      1,
      NULL,
      27,
      0,
      0,
      NULL,
      0.590519,
      ' 5-29-1978',
      3,
      NULL,
      5,
      ' 9-19-2003',
      NULL,
      0.054575,
      ' 4-21-1975',
      8,
      NULL,
      NULL,
      15,
      ' 4- 2-1978',
      8.611807,
      ' 9-18-1991',
      12.885453,
      4.394417,
      ' 8-16-1979',
      NULL,
      NULL,
      NULL,
      13,
      12,
      ' 8-11-1978',
      1.217368,
      NULL,
      ' 1- 2-1995',
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-14-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.032162);
commit;
end;
/


