set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8803914';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '22233344',
      '00402131',
      '13212010',
      '42320303',
      '12414242',
      '22422003',
      '14014131',
      '24140301',
      NULL,
      '40002440',
      '23444331',
      '01240304',
      NULL,
      '23242131',
      '34421102',
      '02001322',
      '40344410',
      '22140130',
      NULL,
      NULL,
      '34334322',
      '01040223',
      '24433220',
      NULL,
      '12222442',
      '03021024',
      NULL,
      '44322300',
      '21043320',
      '20321003',
      '02024024',
      '22424244',
      NULL,
      '33104340',
      '33412120',
      '10331012',
      '41332033',
      '01341430',
      '20114301',
      '32332120',
      '44012134',
      '20412321',
      '24401310',
      '02040244',
      '340',
      '20',
      NULL,
      NULL,
      '1020321',
      1.093136,
      1,
      1,
      NULL,
      '003022',
      3,
      ' 1-16-1993',
      NULL,
      34.928167,
      NULL,
      1,
      15.042872,
      9,
      2.020420,
      49.462104,
      7,
      NULL,
      13.425152,
      17.320641,
      7,
      NULL,
      13.926478,
      4,
      5,
      23,
      29.668854,
      48.885008,
      21.954929,
      21,
      8,
      139.217439,
      12,
      1.079257,
      NULL,
      159.137223,
      34,
      133,
      164.215677,
      188.655785,
      ' 5-22-1980',
      NULL,
      60,
      16,
      32,
      86.776325,
      10,
      ' 7- 8-2000',
      1,
      0.806635,
      4,
      NULL,
      3,
      NULL,
      0,
      1,
      0,
      0.941058,
      NULL,
      0,
      1,
      1.060929,
      1.450257,
      0.816609,
      NULL,
      0.692886,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-12-1990',
      98.091409,
      0,
      5.069600,
      3.589788,
      0,
      NULL,
      '11-12-2000',
      1,
      0,
      53,
      0.335501,
      0,
      177.216469,
      NULL,
      NULL,
      10.599847,
      NULL,
      1,
      NULL,
      ' 8-23-1983',
      24,
      3.934230,
      42.813091,
      92.715510,
      61.475263,
      107.330839,
      NULL,
      9,
      86,
      89,
      84,
      17.656001,
      ' 8-15-1988',
      0,
      16.563891,
      NULL,
      7,
      NULL,
      9.612079,
      8.128650,
      ' 6-26-1978',
      11.635068,
      17.229543,
      NULL,
      12.369128,
      13.839568,
      11.215440,
      15,
      16,
      6,
      NULL,
      1,
      1,
      47,
      1.454808,
      3,
      22.021700,
      16,
      2,
      0.594642,
      3,
      NULL,
      NULL,
      1,
      1,
      0.648485,
      ' 9-25-2001',
      145,
      4,
      ' 2-28-1996',
      30.490051,
      8.306187,
      '11-27-1991',
      12,
      NULL,
      41.399112,
      '10-29-1996',
      15,
      NULL,
      ' 5-18-2001',
      62,
      52,
      NULL,
      5,
      6.196104,
      ' 7- 9-1984',
      9,
      3,
      ' 8- 3-1996',
      NULL,
      2,
      14.034584,
      NULL,
      52.435702,
      2.180342,
      NULL,
      '10- 0-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4);
commit;
end;
/


