set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6109422';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '23103343',
      '10443131',
      '31010003',
      '42120104',
      '21344231',
      '00421240',
      '01033442',
      '30130301',
      '02440220',
      '11400112',
      NULL,
      NULL,
      NULL,
      NULL,
      '03122310',
      '12140442',
      '14204133',
      '13012344',
      '01332210',
      '22012040',
      NULL,
      '30131320',
      '02431303',
      '00420321',
      '44333044',
      '23122304',
      '11224144',
      '22111211',
      '42443221',
      '30134324',
      '34322213',
      NULL,
      '43032031',
      NULL,
      '04221410',
      NULL,
      NULL,
      NULL,
      '00242123',
      NULL,
      '30334104',
      '40434410',
      '30314100',
      '41134414',
      '',
      '',
      NULL,
      NULL,
      '1120021',
      3,
      NULL,
      NULL,
      NULL,
      '432222',
      NULL,
      NULL,
      ' 4- 4-2003',
      23.650353,
      NULL,
      28.734513,
      17.022270,
      12.527124,
      9,
      21.862936,
      5.432815,
      14.651188,
      15,
      20.856949,
      25,
      NULL,
      1,
      10,
      3.499844,
      NULL,
      8,
      42,
      NULL,
      9,
      4,
      78,
      1.440786,
      NULL,
      35.397003,
      181.722052,
      16,
      NULL,
      85,
      152.357830,
      ' 7- 2-1999',
      59.163064,
      40,
      1.303139,
      NULL,
      8,
      59,
      '10- 6-1999',
      0.461245,
      3.769508,
      2,
      0.644475,
      NULL,
      NULL,
      NULL,
      NULL,
      1.742664,
      0,
      0.664092,
      NULL,
      0.475249,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-10-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-10-1994',
      27.045645,
      41,
      51.608151,
      22.877854,
      13,
      30,
      29,
      7.427497,
      NULL,
      54.804450,
      14,
      68,
      ' 3- 7-1986',
      2,
      15,
      4.161270,
      29.743632,
      1,
      59.364632,
      0,
      ' 8-24-2000',
      13.212679,
      4,
      ' 5-24-1993',
      7,
      1.349082,
      8,
      14,
      9,
      NULL,
      NULL,
      0,
      NULL,
      43.702910,
      1.267906,
      NULL,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-12-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26.369223,
      7,
      7,
      ' 0-18-1993',
      NULL,
      127.121872,
      '10- 2-1993',
      NULL,
      NULL,
      6.452714,
      30.657795,
      ' 2-22-1977',
      48,
      1,
      43.929779,
      '10-19-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      116,
      NULL,
      10,
      41.719593,
      133,
      10.927138,
      NULL,
      17,
      NULL,
      9,
      0,
      0.663647,
      0.856311,
      21.068330,
      0.346036,
      1.169361,
      9,
      1,
      3.502452,
      81,
      NULL,
      2.844500,
      187,
      42.096056,
      32,
      12,
      1,
      48,
      1,
      1,
      0.536692,
      1,
      0.265734,
      1,
      61,
      64,
      42,
      NULL,
      29.398342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      35,
      1,
      0.892232,
      NULL,
      32,
      4.069874,
      1.964422,
      37,
      42.469471,
      22,
      51.369942,
      NULL,
      7,
      NULL,
      2,
      1.602542,
      0,
      0,
      1.050395,
      20,
      ' 3-29-1986',
      ' 0-27-1983',
      ' 3-22-1997',
      NULL,
      ' 7-17-1984',
      ' 9-17-1985',
      NULL,
      NULL);
commit;
end;
/


