set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6109422';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2402',
      NULL,
      '33200331',
      '10003340',
      '00030120',
      '30102311',
      '40221230',
      NULL,
      '10030004',
      NULL,
      '14220141',
      '20043103',
      '20001240',
      NULL,
      '04322032',
      '14110410',
      '21342142',
      '12220414',
      '14233030',
      NULL,
      '43212431',
      NULL,
      NULL,
      NULL,
      '41112023',
      '14133312',
      '30442024',
      '04400224',
      NULL,
      '23434122',
      '43113430',
      '42223011',
      NULL,
      '32233241',
      '30203420',
      '12200011',
      '34120423',
      '20131123',
      '32120321',
      '34011114',
      '23301400',
      '00144233',
      '40334044',
      '44323220',
      '23134120',
      '',
      '',
      NULL,
      NULL,
      '1222034',
      1.936512,
      20.459309,
      0,
      NULL,
      NULL,
      NULL,
      ' 4-28-2002',
      ' 3-24-1992',
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      3,
      20.173768,
      29,
      60.884927,
      113.203857,
      NULL,
      1.416188,
      0.197516,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.527018,
      NULL,
      0.211160,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-16-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-21-1976',
      100,
      60.646926,
      92.456498,
      36,
      29.084632,
      93,
      NULL,
      62.412859,
      78,
      64.380881,
      24.093272,
      83,
      '10-27-2000',
      2,
      19,
      10,
      61.919625,
      41.409505,
      69,
      NULL,
      ' 3-29-1979',
      21,
      2,
      ' 4-10-1991',
      6,
      12.683286,
      2,
      7.233129,
      NULL,
      8,
      NULL,
      10.333464,
      NULL,
      10,
      NULL,
      5.829726,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-28-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.741679,
      151,
      ' 0-21-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22.583842,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.902750,
      7.160410,
      0,
      3,
      55,
      1,
      1.135218,
      NULL,
      1.628576,
      3.553809,
      NULL,
      42.720054,
      NULL,
      NULL,
      0,
      18,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      NULL,
      47,
      NULL,
      0.021976,
      5.674243,
      0,
      2,
      NULL,
      5,
      0.503901,
      14,
      NULL,
      15.958213,
      0.797004,
      2.855377,
      75.806657,
      9,
      7,
      NULL,
      1.143153,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      0,
      NULL,
      0,
      0,
      1,
      37.212701,
      NULL,
      NULL,
      NULL,
      ' 9-24-1986',
      ' 4-28-1981',
      NULL,
      ' 4- 9-2003',
      NULL);
commit;
end;
/


