set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9747583';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '3',
      NULL,
      '1',
      NULL,
      '2',
      '1',
      NULL,
      '4',
      NULL,
      '2',
      '1',
      '4',
      '0',
      '0',
      NULL,
      '3',
      '2',
      '3',
      '4',
      '0',
      '0',
      '0',
      '0',
      '',
      '2',
      '',
      NULL,
      '2',
      '1',
      NULL,
      '2',
      NULL,
      '',
      '1',
      '4',
      '4',
      '2',
      '3',
      '2',
      NULL,
      '4',
      '0',
      '2',
      NULL,
      '403',
      '34104242',
      78,
      47.525321,
      '4024120',
      NULL,
      0,
      NULL,
      NULL,
      '314433',
      2.658589,
      ' 9-29-1988',
      ' 6- 4-1984',
      1,
      111.941169,
      10.372762,
      15.924989,
      23,
      10.224641,
      28,
      2.120014,
      10,
      NULL,
      45.962081,
      NULL,
      44,
      5,
      21.494453,
      13.221882,
      9.301062,
      11.218852,
      NULL,
      2.941532,
      4.149813,
      0,
      26.659048,
      17,
      1.704979,
      NULL,
      124.251105,
      NULL,
      NULL,
      NULL,
      129.651940,
      ' 5-28-1995',
      16.433586,
      NULL,
      NULL,
      25.601920,
      NULL,
      34.265225,
      ' 3-19-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      47.540303,
      NULL,
      NULL,
      0.703818,
      0,
      ' 7- 3-1999',
      0,
      1.154202,
      45,
      1.774404,
      0.719193,
      NULL,
      0,
      0,
      31,
      NULL,
      NULL,
      NULL,
      '10-14-1986',
      79,
      84.999887,
      NULL,
      NULL,
      NULL,
      77,
      76,
      33,
      NULL,
      18,
      107,
      84,
      ' 6-28-1982',
      NULL,
      10.183226,
      NULL,
      47.291902,
      28.936291,
      6,
      5.439448,
      '10-23-1987',
      NULL,
      6.679041,
      '10-28-1979',
      11.764200,
      13.025687,
      NULL,
      14.158478,
      26.421480,
      0,
      0,
      13.765413,
      0.122540,
      60.155761,
      0.381363,
      1.904608,
      15,
      29,
      1,
      1,
      2,
      1,
      ' 7- 4-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      15.856211,
      ' 0-28-1999',
      NULL,
      NULL,
      NULL,
      6,
      ' 7- 8-1999',
      6,
      NULL,
      5.879238,
      8.393862,
      ' 5-15-1999',
      85.246506,
      43,
      ' 1-20-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      22,
      ' 4-17-2002',
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      122,
      ' 1-14-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


