set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015749';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0244',
      '14003121',
      '12304022',
      '30113223',
      '43413424',
      '10422020',
      '33142202',
      NULL,
      NULL,
      NULL,
      '40404433',
      '22333331',
      '40323401',
      '40241222',
      '11124331',
      '42222124',
      '33202312',
      '12200334',
      NULL,
      '12203443',
      '43242113',
      '33202240',
      '30110330',
      '30033124',
      '12223312',
      NULL,
      NULL,
      '14412113',
      '30031422',
      '42132111',
      NULL,
      '22011102',
      '40423120',
      '10134111',
      NULL,
      '01420223',
      NULL,
      NULL,
      '31421303',
      '02243032',
      '13123444',
      NULL,
      '14323214',
      '23420023',
      '33103012',
      '',
      '',
      NULL,
      NULL,
      NULL,
      0,
      0.620551,
      2,
      NULL,
      '331144',
      3.116520,
      ' 2- 1-1997',
      '11- 1-1996',
      4,
      NULL,
      23.836767,
      5.030814,
      1.093195,
      6.687619,
      53,
      12.061900,
      13.274516,
      18,
      36.356328,
      8.554761,
      NULL,
      16,
      5,
      14.413873,
      11,
      NULL,
      NULL,
      6,
      39,
      NULL,
      24.937039,
      3,
      NULL,
      90.877702,
      16.099347,
      NULL,
      NULL,
      NULL,
      0,
      ' 3- 5-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      9.209545,
      0.206298,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5.884702,
      0,
      NULL,
      1.433284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-26-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44,
      59.000838,
      NULL,
      78.078353,
      87,
      NULL,
      NULL,
      NULL,
      37.141591,
      NULL,
      92,
      NULL,
      '11-29-1993',
      1.285927,
      6.393173,
      6,
      27,
      53,
      NULL,
      NULL,
      ' 8-22-1984',
      16.793779,
      10.391909,
      ' 3- 6-1986',
      11,
      NULL,
      2,
      16.854785,
      12,
      11,
      NULL,
      3,
      NULL,
      68,
      1,
      2.119041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31,
      27.136549,
      NULL,
      NULL,
      0,
      136.743190,
      ' 1-21-1977',
      9.365416,
      59,
      11,
      20,
      ' 1-19-1995',
      29.222327,
      0,
      46,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      99,
      0.068982,
      19,
      53,
      134,
      70.379288,
      43,
      3,
      24,
      0.779732,
      104,
      0.688669,
      0.204726,
      27,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      82,
      13.801856,
      26.653931,
      0.602965,
      0.457721,
      44,
      1.156262,
      1,
      0,
      0.066758,
      NULL,
      1.476829,
      92,
      17,
      NULL,
      0.687903,
      25,
      NULL,
      0.133515,
      0,
      NULL,
      1,
      NULL,
      1.561902,
      NULL,
      1.189109,
      68.319277,
      1.171470,
      104.587113,
      1,
      1.483414,
      44,
      26.447600,
      6,
      15.787528,
      53.380097,
      NULL,
      NULL,
      NULL,
      7,
      6,
      0.814299,
      2,
      1,
      0,
      NULL,
      0.103923,
      75,
      '10-27-1974',
      ' 4-24-2001',
      NULL,
      ' 5-17-1986',
      ' 4- 9-1980',
      NULL,
      ' 0- 3-2003',
      NULL);
commit;
end;
/


