set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9675175';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1140',
      '04342401',
      '12143420',
      '10313000',
      '00223331',
      '01141442',
      '34114403',
      '14230032',
      '02022223',
      '01032223',
      NULL,
      '42130201',
      '42204103',
      '41011103',
      '40131110',
      NULL,
      '11423432',
      '02212042',
      '41131432',
      '32343311',
      '12214304',
      '21023044',
      '01001043',
      '40032322',
      '11130233',
      '22440443',
      '30333010',
      '03421130',
      '10421031',
      '30023141',
      '13301411',
      '30340132',
      NULL,
      '34130330',
      '41011304',
      '31014030',
      '11131333',
      NULL,
      '00430343',
      NULL,
      NULL,
      '41444204',
      '30040002',
      '30134432',
      '03433340',
      '322',
      '21',
      19,
      10.497169,
      '4234122',
      3.484389,
      NULL,
      3,
      NULL,
      '314214',
      NULL,
      NULL,
      NULL,
      108.373435,
      56,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.214307,
      NULL,
      NULL,
      26.846965,
      NULL,
      18.278106,
      13,
      NULL,
      5.393203,
      4,
      5.757575,
      24.521693,
      7,
      NULL,
      0,
      NULL,
      NULL,
      1.857797,
      NULL,
      55.712440,
      35,
      59,
      NULL,
      83.730783,
      ' 9-28-1975',
      8.722256,
      28,
      NULL,
      24,
      17,
      27,
      ' 0-28-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      59.414277,
      22,
      43.654343,
      22,
      5,
      3,
      ' 0-16-1983',
      0,
      1,
      22,
      1.312925,
      1,
      62,
      0,
      0,
      36,
      NULL,
      NULL,
      NULL,
      NULL,
      27.506208,
      NULL,
      62,
      NULL,
      77.926813,
      96,
      9.884534,
      23.174630,
      15,
      87,
      70,
      NULL,
      '11-14-1988',
      23,
      NULL,
      NULL,
      4,
      39,
      77,
      6,
      ' 9- 0-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      ' 1- 3-1975',
      NULL,
      NULL,
      NULL,
      31,
      NULL,
      5.950331,
      ' 8-26-2002',
      7.704707,
      9.559876,
      '11-25-2002',
      62,
      85.885340,
      '11-21-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.159881,
      ' 1-17-1987',
      NULL,
      8,
      7,
      ' 8-26-1988',
      0,
      3,
      ' 6-20-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


