set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9748849';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      '4',
      '1',
      '0',
      '4',
      NULL,
      '4',
      '4',
      '0',
      '0',
      '0',
      '0',
      '0',
      '3',
      '2',
      '1',
      '0',
      '2',
      NULL,
      '1',
      '2',
      NULL,
      '2',
      NULL,
      '3',
      '',
      '3',
      '3',
      '2',
      '4',
      '2',
      '',
      NULL,
      '4',
      '2',
      '4',
      '1',
      '3',
      '4',
      '0',
      '0',
      '3',
      '4',
      NULL,
      '103',
      '04240110',
      25,
      NULL,
      '1320410',
      3.727179,
      0,
      0,
      NULL,
      '424143',
      NULL,
      ' 8-22-1993',
      ' 9-13-1997',
      43,
      196,
      NULL,
      NULL,
      36,
      25,
      9,
      1,
      5,
      26,
      NULL,
      NULL,
      26,
      8,
      18,
      22.884862,
      0.293097,
      14,
      NULL,
      11.813735,
      3.959185,
      20,
      NULL,
      NULL,
      0.977806,
      114,
      125.714372,
      75,
      NULL,
      18,
      143,
      ' 6-13-1998',
      43,
      46.031335,
      13,
      30,
      44,
      42.439820,
      ' 8-12-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      18.002810,
      7.809444,
      NULL,
      4.113832,
      3,
      ' 0- 0-1997',
      NULL,
      1,
      6,
      0.863580,
      3.386893,
      NULL,
      0.887582,
      1.935737,
      91,
      NULL,
      NULL,
      NULL,
      NULL,
      44.264508,
      NULL,
      98,
      1,
      NULL,
      NULL,
      95.615829,
      88.886831,
      77,
      34.786472,
      NULL,
      98,
      '11- 0-1978',
      NULL,
      4,
      25,
      13,
      68.145068,
      NULL,
      6.940573,
      ' 5-16-1991',
      0.121440,
      20.929023,
      '10- 6-1988',
      3,
      2.282165,
      0.431265,
      14,
      10,
      2,
      0.847266,
      NULL,
      0.986675,
      38,
      1.363391,
      0.567921,
      NULL,
      NULL,
      0.534711,
      0.311034,
      NULL,
      1,
      ' 8-12-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      126,
      NULL,
      ' 5-23-1986',
      NULL,
      NULL,
      NULL,
      39.995241,
      NULL,
      32,
      ' 2- 7-1986',
      3,
      3.559849,
      NULL,
      92,
      NULL,
      ' 2- 0-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      ' 7- 4-1994',
      12,
      8,
      1,
      ' 0-10-1989',
      2,
      83,
      ' 6-25-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


