set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9231174';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0012',
      '30034002',
      '04204302',
      '03300113',
      '00344421',
      '40122022',
      '00200404',
      '34243311',
      '44200413',
      '30024130',
      '22244022',
      NULL,
      '22333223',
      '44113030',
      '23131132',
      '41134014',
      '41032110',
      NULL,
      '03021231',
      NULL,
      NULL,
      '00401422',
      '40434244',
      NULL,
      '33220113',
      '03000404',
      '24034101',
      '01424120',
      '11024032',
      '13212000',
      '03113201',
      '01342231',
      NULL,
      NULL,
      NULL,
      '14201111',
      '21044344',
      '24204333',
      '21002241',
      NULL,
      NULL,
      '11210303',
      '42414123',
      '33422230',
      '20142444',
      '123',
      NULL,
      NULL,
      NULL,
      '2022301',
      NULL,
      1.466778,
      1,
      NULL,
      '202001',
      4,
      '10- 9-1990',
      ' 0- 1-1981',
      48,
      NULL,
      8,
      2.348008,
      NULL,
      10,
      87,
      18,
      10,
      31,
      28.626907,
      11.134414,
      10.644191,
      25,
      24,
      NULL,
      28.499732,
      8,
      NULL,
      NULL,
      19,
      11,
      NULL,
      NULL,
      3,
      95.676228,
      126.729319,
      118.684335,
      219,
      123,
      92,
      ' 6-23-1990',
      50,
      56,
      24,
      30,
      191.801817,
      144.893442,
      ' 1- 3-1988',
      1.242452,
      NULL,
      1,
      1.306144,
      1,
      NULL,
      0.479371,
      1,
      0,
      1.075444,
      1.648345,
      1,
      NULL,
      3.454860,
      NULL,
      1,
      3,
      1.645066,
      0.176252,
      0.527948,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-28-1980',
      83.171793,
      10.035078,
      5.619095,
      NULL,
      5.843603,
      8,
      NULL,
      NULL,
      1.819462,
      225,
      1,
      NULL,
      NULL,
      3.336578,
      1.430173,
      32.479705,
      1.181218,
      1.317864,
      61,
      '10- 8-2002',
      NULL,
      48.813081,
      NULL,
      62.921564,
      71,
      30.109039,
      36.471259,
      17,
      59,
      84.127070,
      39,
      92.939110,
      ' 3-20-1977',
      0,
      11,
      6.552661,
      2.645530,
      18,
      71.130128,
      8,
      '10- 2-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.177338,
      0.901101,
      5,
      NULL,
      165.067172,
      NULL,
      ' 4-23-1981',
      4,
      NULL,
      NULL,
      NULL,
      ' 6- 9-1982',
      10.115387,
      ' 8- 7-1982',
      2.462924,
      11.252985,
      ' 2- 5-1999',
      10.622298,
      17.256762,
      ' 7-11-1993',
      NULL,
      6,
      ' 5- 0-1974',
      NULL,
      NULL,
      ' 8-24-1978',
      NULL,
      3,
      0,
      ' 4-20-1990',
      NULL,
      41,
      54.893653,
      ' 5- 2-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10);
commit;
end;
/


