set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9009279';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2203',
      NULL,
      '02004222',
      NULL,
      '32310322',
      '34121403',
      '34203402',
      NULL,
      '04120131',
      NULL,
      '11031410',
      '41401222',
      '33230134',
      '01440040',
      '21202340',
      '34224311',
      '30212044',
      '22103213',
      '20322301',
      '10013002',
      '33241412',
      '41420311',
      '30430101',
      '40422304',
      '42324131',
      '10422203',
      '12303231',
      '22243230',
      '44342444',
      '10343034',
      '44202022',
      NULL,
      NULL,
      '34343341',
      '21140304',
      '32202144',
      '01024403',
      NULL,
      '30314242',
      '32204314',
      '00311040',
      '32441201',
      '41231011',
      '33444211',
      '43200320',
      NULL,
      NULL,
      NULL,
      NULL,
      '4212443',
      3,
      0,
      0,
      NULL,
      '244313',
      NULL,
      ' 9-29-1996',
      ' 8- 7-1988',
      NULL,
      NULL,
      31.488528,
      4,
      29.878458,
      22,
      28,
      15,
      28,
      NULL,
      26.720877,
      14.528429,
      5.316730,
      0.542705,
      NULL,
      7.057728,
      2.989408,
      NULL,
      48.790835,
      NULL,
      NULL,
      6.210779,
      13.483471,
      NULL,
      NULL,
      7,
      NULL,
      57,
      95.480229,
      48,
      92,
      '10-12-2002',
      53,
      38,
      9,
      5,
      172.691981,
      188.812554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-19-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      20.662700,
      3.755207,
      21.245533,
      37.244796,
      18,
      2,
      '11- 9-2002',
      30.919393,
      NULL,
      ' 2-25-1980',
      6.492844,
      18,
      19.009976,
      11,
      4.051340,
      NULL,
      NULL,
      28,
      NULL,
      70.509607,
      0.994757,
      5,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-19-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      62.858785,
      NULL,
      0,
      '11-18-1998',
      NULL,
      NULL,
      ' 7-15-2002',
      7,
      4.461315,
      8,
      NULL,
      ' 6-10-1987',
      15.051388,
      1.956591,
      NULL,
      ' 6-15-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      64.906754,
      12,
      5,
      27.615439,
      4,
      10,
      NULL,
      1.766330,
      0,
      37.915251,
      1,
      0,
      60,
      0.495205,
      0.382835,
      96.835084,
      1,
      4.942606,
      NULL,
      NULL,
      15.363581,
      NULL,
      1,
      NULL,
      1.579842,
      0,
      0.063280,
      30.665584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      NULL,
      NULL,
      1.188552,
      NULL,
      NULL,
      0.327567,
      NULL,
      3,
      NULL,
      1.826142,
      NULL,
      0.543860,
      NULL,
      0,
      1.311157,
      NULL,
      5,
      15.885712,
      31,
      NULL,
      NULL,
      10.169103,
      NULL,
      4,
      8.798294,
      0.412041,
      NULL,
      3,
      0.500913,
      1.972371,
      1,
      NULL,
      ' 8- 7-1994',
      ' 0- 7-1985',
      ' 3-13-1981',
      ' 8-22-1977',
      ' 8- 6-1999',
      '11- 9-1988',
      ' 2-29-1992',
      NULL);
commit;
end;
/


