set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8305338';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      '11140122',
      '03024012',
      '40324020',
      '43024324',
      '22204033',
      '03211203',
      '34042042',
      '33230421',
      '43330201',
      NULL,
      '10314243',
      '22044310',
      '42122423',
      '41041014',
      '31432031',
      '01103324',
      '30234020',
      '33044313',
      '10431431',
      '14032043',
      '02344333',
      NULL,
      '43030344',
      '12321401',
      '41004343',
      '00101143',
      '20434344',
      '13341011',
      '14232221',
      '04011320',
      NULL,
      '22233100',
      '03433140',
      '30414103',
      '10203122',
      '11011400',
      NULL,
      '30030333',
      '20202202',
      '41113001',
      NULL,
      '00221430',
      '133',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      NULL,
      '341424',
      4,
      ' 0- 7-1978',
      ' 5-16-1975',
      33,
      NULL,
      38.438014,
      5.697133,
      13,
      0,
      65.028637,
      9.195941,
      3,
      17,
      32.114235,
      14,
      NULL,
      11,
      24,
      14.205894,
      11,
      NULL,
      21.191596,
      16.445836,
      16.186718,
      5,
      NULL,
      15,
      0,
      71,
      98,
      33.619983,
      78.915152,
      184.515307,
      NULL,
      ' 2- 5-1983',
      6.302199,
      42.751491,
      NULL,
      33,
      26,
      14.096146,
      ' 2-13-1980',
      1,
      0,
      NULL,
      NULL,
      1.080830,
      1,
      7,
      0.174081,
      0.094362,
      0,
      1,
      0.230402,
      NULL,
      3.433192,
      NULL,
      1.320039,
      1,
      0,
      1.002416,
      0.883554,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 2-1997',
      NULL,
      20,
      8.684085,
      4.161701,
      14,
      11,
      ' 4-19-2003',
      1,
      0,
      102,
      1.876443,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 9-1978',
      64.866805,
      NULL,
      16,
      84.095077,
      73,
      52,
      4.580511,
      80.856599,
      103,
      68.054366,
      40,
      94.095334,
      ' 5-17-1983',
      5.186913,
      7.272174,
      1.288910,
      63.371625,
      18,
      22,
      5,
      NULL,
      24.690595,
      12,
      NULL,
      3.523181,
      5.047565,
      16.523593,
      4,
      NULL,
      3,
      0.641297,
      0,
      0.544555,
      NULL,
      1.167264,
      3,
      5.805001,
      12,
      3.840490,
      1,
      1.524878,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      121,
      6,
      '10- 0-1983',
      NULL,
      NULL,
      NULL,
      4,
      ' 0-23-1974',
      15,
      ' 8-17-1981',
      0,
      3.190037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-23-1977',
      NULL,
      NULL,
      NULL,
      0,
      1,
      12,
      '11- 3-1990',
      57,
      25,
      35,
      ' 6-11-1999',
      0.984384,
      49.165669,
      '10-16-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


