set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924209';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0444',
      '11233301',
      '42440130',
      '21111010',
      '41014141',
      NULL,
      '11342401',
      '42441200',
      '04004103',
      '32014314',
      '14444441',
      '13030220',
      NULL,
      NULL,
      NULL,
      '24213321',
      '14001131',
      '00241301',
      '42421301',
      '03232242',
      '33402340',
      '20244044',
      '34034442',
      '32310442',
      '14243330',
      '42322323',
      '10012341',
      '34314200',
      '03010304',
      '21324302',
      NULL,
      '10033103',
      '00222334',
      '22012321',
      '20422134',
      '44004424',
      '23203230',
      NULL,
      '44433044',
      '41421230',
      '44433344',
      NULL,
      '32112332',
      '33410004',
      '01114042',
      '',
      '',
      NULL,
      NULL,
      '3331100',
      3.759998,
      1,
      3,
      NULL,
      '232344',
      3,
      ' 1-16-1983',
      NULL,
      33,
      NULL,
      39.182576,
      NULL,
      25,
      8.389467,
      80.360226,
      3,
      21.055598,
      NULL,
      29.879540,
      NULL,
      20.333887,
      NULL,
      NULL,
      NULL,
      24,
      NULL,
      77,
      NULL,
      39.820955,
      4.587399,
      95,
      23,
      NULL,
      NULL,
      138.787539,
      12,
      118,
      198.796077,
      86.716768,
      ' 1-24-1990',
      33.064349,
      8,
      NULL,
      20,
      95,
      122.125382,
      ' 1- 3-1989',
      1,
      NULL,
      2.649389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1,
      1.194953,
      2.328718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-13-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 6-1974',
      37,
      21.267732,
      21,
      126,
      79.366120,
      114,
      62.396228,
      77.827594,
      8,
      9,
      28,
      18,
      ' 6- 3-1983',
      20,
      NULL,
      27.343345,
      33,
      74,
      169,
      7.911793,
      ' 8- 8-1983',
      21.141902,
      0,
      ' 7-17-1987',
      NULL,
      20,
      NULL,
      24,
      NULL,
      5,
      NULL,
      0,
      NULL,
      66.282710,
      5,
      5.682128,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-20-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      62,
      NULL,
      2,
      ' 2-20-1997',
      0.853948,
      96.394965,
      ' 7-21-1980',
      15,
      8,
      2,
      9.787909,
      ' 9- 3-1998',
      22.726801,
      0,
      51.676095,
      ' 0-19-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      NULL,
      95,
      9,
      NULL,
      5,
      6,
      8,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      51.561573,
      5,
      NULL,
      28,
      4,
      2.907102,
      73,
      NULL,
      21,
      NULL,
      NULL,
      NULL,
      2,
      0.420523,
      1.174491,
      1.869450,
      NULL,
      0.304003,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.256874,
      1,
      2.069792,
      0,
      1,
      1.027827,
      41,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.155808,
      1.506559,
      0.126902,
      NULL,
      ' 7-28-1974',
      NULL,
      ' 9-23-2001',
      NULL,
      ' 2-17-1994',
      ' 9-24-1986',
      ' 1- 6-1992',
      NULL);
commit;
end;
/


