set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9645393';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0224',
      NULL,
      NULL,
      NULL,
      '10114101',
      '40021333',
      '04203144',
      '12222400',
      '42331003',
      '10124331',
      '11344444',
      '32324242',
      NULL,
      '12204201',
      '03443310',
      '11422433',
      '44430341',
      '00001023',
      NULL,
      '12410112',
      '31204203',
      NULL,
      '31312113',
      '14110120',
      '41434232',
      '21111403',
      NULL,
      '43034230',
      '31431024',
      NULL,
      '42244344',
      NULL,
      '24232203',
      '41022322',
      '32322420',
      '21310220',
      '33401100',
      NULL,
      '21024331',
      NULL,
      '22331123',
      '40340023',
      '01040303',
      NULL,
      '30323041',
      '343',
      NULL,
      5,
      NULL,
      '1441112',
      2.080998,
      0,
      0,
      NULL,
      '014323',
      4.270797,
      ' 9-11-1995',
      ' 5-22-2003',
      63,
      104.982543,
      15.064988,
      8.159087,
      27,
      6.566017,
      94.790224,
      8,
      1,
      9.308812,
      NULL,
      NULL,
      17.557469,
      21.638007,
      NULL,
      15,
      17,
      10.341225,
      5,
      17.330972,
      0,
      9.929142,
      29.541423,
      1,
      0,
      44,
      19,
      46.000814,
      149.444958,
      NULL,
      79.735612,
      '11-14-1979',
      48,
      41,
      8.045506,
      2.365601,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32.084927,
      7.161841,
      20,
      NULL,
      8,
      NULL,
      '11-24-1984',
      NULL,
      0,
      176,
      1.310082,
      1.208130,
      NULL,
      1,
      1.572063,
      87.289996,
      NULL,
      NULL,
      NULL,
      '10- 6-1994',
      98,
      40.683464,
      89,
      60,
      NULL,
      NULL,
      32.019402,
      21.092627,
      18,
      21,
      97.481115,
      8,
      NULL,
      27,
      15,
      9.179051,
      42,
      26,
      111,
      1,
      NULL,
      9,
      NULL,
      ' 4- 6-1994',
      8,
      NULL,
      NULL,
      18.916708,
      NULL,
      7.218433,
      NULL,
      4,
      0,
      24.918794,
      0,
      0.371462,
      7.176687,
      5.413889,
      1,
      NULL,
      0,
      0,
      ' 2- 6-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.856628,
      '10-20-1995',
      NULL,
      NULL,
      NULL,
      32,
      ' 7-24-1991',
      NULL,
      ' 0-29-2003',
      7,
      0.266950,
      ' 6- 7-1980',
      4,
      NULL,
      ' 0-18-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      20,
      NULL,
      27.837811,
      NULL,
      0.133170,
      '11-16-1979',
      NULL,
      77.301799,
      ' 8- 4-1991',
      6,
      4.965874,
      19.890942,
      41,
      NULL,
      47,
      1,
      171.814662,
      ' 8-14-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


