set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '40422343',
      NULL,
      '24410414',
      '04043140',
      '42221003',
      NULL,
      '00322244',
      '24234211',
      '22124022',
      '22020030',
      '22102433',
      '10114340',
      '12424320',
      '30033142',
      '34312212',
      '41140204',
      '23441014',
      NULL,
      '33243412',
      '04232114',
      NULL,
      NULL,
      '13032302',
      '34241223',
      '24243434',
      '40403101',
      '34242303',
      '42211223',
      '22104220',
      '42203140',
      NULL,
      '11201222',
      NULL,
      '11020142',
      '13032123',
      '01420403',
      '11210343',
      '42040130',
      '42110240',
      NULL,
      NULL,
      '30234014',
      '13332044',
      '31110244',
      '131',
      '31',
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      5.363623,
      NULL,
      ' 3-10-1990',
      NULL,
      NULL,
      8.743189,
      NULL,
      1.972478,
      4.498827,
      19.027343,
      3.094468,
      0,
      0,
      6.594313,
      3,
      0,
      2.871586,
      17,
      5,
      2,
      8,
      NULL,
      NULL,
      20.748403,
      8.883947,
      38,
      NULL,
      1.476021,
      NULL,
      0,
      10,
      53,
      32,
      77,
      ' 3-23-1984',
      NULL,
      3,
      NULL,
      13,
      NULL,
      NULL,
      '10- 3-1991',
      NULL,
      NULL,
      10,
      15.104971,
      0,
      20,
      7,
      17.298364,
      0,
      NULL,
      NULL,
      NULL,
      3.621191,
      3,
      NULL,
      2,
      11,
      2.962443,
      1.177270,
      20,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-19-1992',
      34.028968,
      16,
      23,
      NULL,
      NULL,
      5.580874,
      '10-27-1997',
      0.905150,
      NULL,
      13,
      0.717198,
      1,
      14,
      1,
      4.288372,
      2.688331,
      NULL,
      NULL,
      NULL,
      ' 2-19-1975',
      3,
      71.312829,
      19,
      39.025215,
      24,
      NULL,
      30,
      3,
      11,
      79,
      10.148633,
      28,
      ' 0-25-1992',
      8,
      9.164817,
      9.516101,
      12,
      32,
      3,
      4,
      '11-25-1976',
      3.814669,
      0.725904,
      '11- 9-1983',
      0,
      4,
      1.677323,
      3.405455,
      6,
      2.427508,
      1,
      NULL,
      0,
      37.049663,
      28,
      1.909522,
      2,
      2.300755,
      4.193712,
      7,
      2.253358,
      2.737505,
      '10-16-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      21.708767,
      NULL,
      ' 3-22-1993',
      NULL,
      NULL,
      NULL,
      32,
      '11-24-1979',
      18.142853,
      NULL,
      NULL,
      4,
      ' 5-18-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      0.119280,
      ' 7- 5-1990',
      NULL,
      NULL,
      NULL,
      2,
      2,
      14.040260,
      ' 8- 6-2002',
      14.990262,
      0.701602,
      NULL,
      ' 3-18-1978',
      2.663794,
      502.687445,
      NULL,
      3.805666,
      NULL,
      1.120355,
      171,
      NULL,
      46,
      1,
      71,
      ' 5-11-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


