set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2430',
      '44211303',
      '20024143',
      '10243322',
      '12402134',
      '31323342',
      NULL,
      NULL,
      '13030100',
      '02242220',
      '01030323',
      '23214440',
      '20414113',
      '13413012',
      '33434110',
      '13433234',
      '40123320',
      '20413244',
      '32302331',
      '14203433',
      '34112223',
      '20324432',
      '44431103',
      '43304240',
      '01433030',
      '01202430',
      NULL,
      '32413322',
      '11312121',
      '30303313',
      '42422432',
      '24213210',
      '33212144',
      '03130011',
      '03040422',
      '23422212',
      '24414041',
      '44322102',
      '24112400',
      '11201403',
      '02434102',
      '13034424',
      '03330140',
      NULL,
      '34300301',
      '311',
      '04',
      NULL,
      NULL,
      '2341413',
      NULL,
      167,
      NULL,
      NULL,
      '023340',
      0.506208,
      ' 6-17-1983',
      NULL,
      85.721531,
      87.328368,
      7,
      7,
      5.981917,
      1,
      13.264061,
      7,
      2.346386,
      1,
      7,
      6.767163,
      1,
      1,
      20.896906,
      NULL,
      2.469779,
      2,
      NULL,
      NULL,
      8,
      5.690396,
      32.183338,
      7,
      1.378245,
      9,
      123,
      47,
      96.532475,
      1.955838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      27,
      NULL,
      NULL,
      0.318909,
      0.960730,
      ' 8-19-1976',
      1.501375,
      NULL,
      109,
      0.752384,
      NULL,
      NULL,
      1.345629,
      1.941358,
      1.714345,
      NULL,
      NULL,
      NULL,
      '11- 6-2002',
      NULL,
      84.248130,
      117,
      NULL,
      6,
      NULL,
      65.828880,
      90.892827,
      59,
      66,
      62,
      100.831268,
      ' 4-29-2002',
      3.586385,
      0.561948,
      2,
      8.706769,
      15,
      3.283172,
      NULL,
      ' 2-24-1997',
      1.056365,
      0,
      ' 5-28-1981',
      2,
      0.549824,
      5,
      2,
      11,
      NULL,
      3.101195,
      2.518362,
      1,
      27.126801,
      2.659133,
      1.557241,
      5,
      6,
      1,
      6.763891,
      1,
      3.474980,
      ' 6- 9-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.876908,
      ' 5-13-1974',
      14.852059,
      ' 0-29-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3.453158,
      ' 5- 0-2003',
      NULL,
      19,
      7.451409,
      ' 3-26-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      115.244375,
      ' 8-26-1974',
      50,
      1.111678,
      200.510477,
      ' 0- 7-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


