set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      '4',
      '4',
      '2',
      '3',
      '3',
      '1',
      '2',
      '1',
      NULL,
      '2',
      '1',
      NULL,
      '2',
      NULL,
      NULL,
      '3',
      '1',
      '0',
      '4',
      '2',
      '3',
      '2',
      '',
      '0',
      '',
      '1',
      NULL,
      '0',
      '4',
      '1',
      '',
      NULL,
      '1',
      '2',
      '3',
      '3',
      '2',
      NULL,
      '0',
      '0',
      '4',
      NULL,
      '0',
      '043',
      '44241320',
      64.846128,
      16,
      '0314234',
      3.256183,
      259,
      NULL,
      NULL,
      '230031',
      5,
      '11-21-2003',
      ' 2-26-2000',
      65,
      NULL,
      4.982398,
      3.160658,
      7.783938,
      NULL,
      21,
      0.832494,
      3.697423,
      7.866651,
      3.756536,
      NULL,
      0.367975,
      2.975841,
      NULL,
      NULL,
      4,
      8,
      13.202110,
      9.363390,
      17,
      4.252428,
      NULL,
      NULL,
      0,
      26.133231,
      13.341558,
      54,
      41,
      24.759016,
      NULL,
      ' 0- 6-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      56.219983,
      56,
      9,
      18.932469,
      13.483152,
      NULL,
      ' 1-28-1984',
      NULL,
      1,
      116.076105,
      1,
      NULL,
      8.224366,
      13.616907,
      5.627223,
      8.477179,
      NULL,
      NULL,
      NULL,
      ' 3-22-1991',
      NULL,
      21.561539,
      12.326457,
      21,
      3.511399,
      NULL,
      58.720984,
      9.451637,
      42,
      NULL,
      69.690121,
      98,
      ' 4- 2-2002',
      4.528932,
      4.569324,
      1.240260,
      NULL,
      10.083758,
      2,
      3.595366,
      '10-27-1991',
      NULL,
      NULL,
      ' 5-10-2003',
      1.846880,
      9,
      1.618857,
      4,
      1.886938,
      2,
      1,
      3.142702,
      1.008907,
      23.243015,
      8,
      0.279975,
      1.432952,
      14,
      1.632181,
      20,
      7,
      NULL,
      ' 2-28-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      ' 8-21-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      ' 3-10-1991',
      NULL,
      2,
      0.998965,
      ' 1- 1-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      101,
      9,
      NULL,
      ' 7- 7-1977',
      42.232529,
      NULL,
      NULL,
      ' 2-17-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


