set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9811904';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      '3',
      '3',
      '3',
      NULL,
      '3',
      '3',
      '1',
      '3',
      '3',
      '3',
      '4',
      NULL,
      NULL,
      '0',
      '4',
      '1',
      '0',
      NULL,
      NULL,
      '3',
      '0',
      '1',
      NULL,
      '2',
      '',
      '1',
      '4',
      NULL,
      '4',
      '4',
      NULL,
      '',
      '2',
      '2',
      '0',
      NULL,
      '1',
      NULL,
      '1',
      '4',
      '4',
      '1',
      '3',
      '330',
      NULL,
      54.666349,
      NULL,
      '0402414',
      1.531671,
      42,
      NULL,
      1,
      '012211',
      3.584402,
      NULL,
      '10-19-1983',
      66,
      96.535763,
      0.993379,
      NULL,
      22,
      NULL,
      9.070120,
      1.395742,
      3,
      8,
      8,
      NULL,
      23,
      7,
      NULL,
      3,
      18.977829,
      5,
      43.291592,
      5.696728,
      47,
      4,
      33.755978,
      5.593333,
      1,
      44,
      145,
      79.747587,
      NULL,
      141,
      2,
      ' 8-28-1976',
      17,
      7.813081,
      8,
      14,
      2,
      175,
      ' 2-23-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      74,
      NULL,
      16.370650,
      NULL,
      16.232501,
      3,
      ' 5-19-1996',
      1.012879,
      NULL,
      64,
      0,
      0,
      43,
      0.328337,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-26-1983',
      20,
      99.129042,
      28.588558,
      NULL,
      66.418072,
      68,
      62.962945,
      38.202474,
      NULL,
      40,
      2.324006,
      56,
      ' 0-26-1978',
      6.391608,
      NULL,
      20.986313,
      9.580424,
      NULL,
      22.091022,
      0.344267,
      ' 4-26-1995',
      2.170245,
      9.841653,
      ' 0- 8-2001',
      NULL,
      2.106167,
      9.837211,
      NULL,
      5,
      1,
      0,
      8.214707,
      0,
      15.027008,
      0,
      NULL,
      5.887780,
      12.646120,
      0,
      2,
      0.758901,
      0.892920,
      ' 9-21-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      3,
      ' 3- 1-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      '10-26-1983',
      17,
      ' 0-14-1994',
      14,
      NULL,
      NULL,
      80,
      4.873297,
      ' 5-12-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1.258938,
      '11- 8-1996',
      24.673953,
      11.483146,
      21.399343,
      ' 0-10-1983',
      1.870868,
      13,
      ' 2-25-1974',
      11.264565,
      68.940471,
      NULL,
      95,
      ' 2-10-2001',
      NULL,
      NULL,
      119,
      ' 3-26-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


