set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6805689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1414',
      '22203023',
      '01110424',
      '20403040',
      NULL,
      '40202123',
      '01030304',
      NULL,
      '01213124',
      '33103422',
      '11442121',
      NULL,
      NULL,
      '13302122',
      '01414044',
      '22311301',
      '23100000',
      '23310120',
      '01221423',
      '41111133',
      '14303433',
      NULL,
      NULL,
      NULL,
      '11413334',
      '30211422',
      '23233240',
      '22112311',
      '34342401',
      '14242022',
      '00444333',
      '14221310',
      '44134423',
      '03421333',
      '11141121',
      NULL,
      '44144104',
      '34444203',
      '42011142',
      '03330012',
      '01033441',
      '23310324',
      '04430121',
      NULL,
      '21220420',
      '400',
      NULL,
      NULL,
      NULL,
      '0102434',
      3,
      1,
      3,
      NULL,
      '331120',
      NULL,
      ' 9- 2-1992',
      NULL,
      60.795580,
      NULL,
      12,
      11,
      11.110183,
      1.993407,
      NULL,
      NULL,
      9,
      19.349066,
      13,
      0,
      4,
      3,
      NULL,
      NULL,
      21.121871,
      NULL,
      20.773943,
      NULL,
      NULL,
      NULL,
      44.268408,
      NULL,
      0,
      105.749505,
      157.062783,
      23.582864,
      158.921873,
      NULL,
      123.563004,
      ' 9- 3-1984',
      NULL,
      13,
      22,
      26,
      NULL,
      41,
      NULL,
      0,
      2,
      NULL,
      2.958423,
      NULL,
      2,
      0.760881,
      4.354847,
      0,
      1.590821,
      2,
      NULL,
      0,
      3,
      0,
      0,
      NULL,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45.069256,
      35,
      21.437846,
      1.976519,
      26.065900,
      0.378465,
      NULL,
      1.577981,
      2.748323,
      88,
      1,
      0.955769,
      134.024855,
      NULL,
      0,
      90,
      NULL,
      NULL,
      NULL,
      ' 5-25-2003',
      89,
      49,
      NULL,
      63,
      46,
      40,
      53.188588,
      3.558499,
      NULL,
      7,
      NULL,
      18.632252,
      NULL,
      15,
      0,
      0.304729,
      43,
      56,
      NULL,
      NULL,
      ' 9- 7-1978',
      NULL,
      19.920258,
      ' 3-16-1986',
      9.091579,
      0.328889,
      6,
      18.113925,
      8.963034,
      10.532193,
      0,
      5,
      1.607626,
      20,
      1,
      3.550155,
      1.953338,
      7,
      1,
      0.450410,
      1.742181,
      0.465676,
      ' 5-13-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      36.675548,
      15.527714,
      ' 9-10-1975',
      NULL,
      NULL,
      NULL,
      55,
      ' 3-26-1997',
      NULL,
      '10- 9-1976',
      0,
      10.346366,
      ' 4-15-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      12,
      ' 0- 3-1983',
      29,
      27,
      NULL,
      ' 7-15-1974',
      0,
      18,
      ' 9- 6-2003',
      2.555068,
      30.315366,
      NULL,
      NULL,
      NULL,
      61,
      0,
      25.812071,
      ' 5- 5-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


