set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6805689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4204',
      '13214040',
      '21133340',
      '22020303',
      '11033120',
      '14202120',
      '12431123',
      '22032121',
      '30141414',
      '34321243',
      '10443442',
      '42213413',
      '34302341',
      '40133333',
      NULL,
      '21103334',
      '20033313',
      '43102334',
      '30041233',
      '31314410',
      '00010140',
      '03332233',
      NULL,
      '42234113',
      '44334110',
      NULL,
      '32234022',
      '12240314',
      NULL,
      '44044333',
      '22032034',
      '11344204',
      '24314134',
      '12320211',
      '31124220',
      '30423422',
      NULL,
      '02310102',
      '03113403',
      '32041310',
      '40041142',
      NULL,
      '01223030',
      '14422013',
      '13042441',
      '421',
      '11',
      23.265444,
      NULL,
      NULL,
      1.512155,
      17.885610,
      0,
      NULL,
      '144303',
      NULL,
      ' 2-29-1988',
      ' 9-10-2002',
      43,
      80.649288,
      15.090100,
      15,
      18.118806,
      3.179365,
      20.781400,
      NULL,
      16,
      NULL,
      3,
      NULL,
      30.164849,
      NULL,
      9,
      16,
      14.751901,
      2,
      2.484282,
      4,
      2,
      6.573162,
      9,
      13,
      NULL,
      NULL,
      66,
      26.307760,
      132.049371,
      126,
      36,
      ' 2-29-1995',
      22.352753,
      10.483844,
      23,
      14.835987,
      30,
      34.857394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46,
      7,
      28.676817,
      28.605693,
      18.280933,
      1.019994,
      NULL,
      1,
      NULL,
      100.225101,
      1,
      0,
      128.690590,
      0.648411,
      NULL,
      52.056435,
      NULL,
      NULL,
      NULL,
      ' 0-20-1986',
      NULL,
      NULL,
      82,
      91.447062,
      72.464986,
      37.491012,
      25.304534,
      42.861379,
      85,
      33.053338,
      70.635636,
      73,
      '10-18-1974',
      14.152307,
      NULL,
      17.381423,
      NULL,
      69.077402,
      66.817712,
      NULL,
      ' 1- 7-1995',
      33.340723,
      NULL,
      ' 0-19-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      28,
      2,
      ' 6- 1-1976',
      NULL,
      NULL,
      NULL,
      46,
      ' 7-27-1987',
      43.713831,
      ' 3-13-1976',
      11.820777,
      9,
      ' 4- 9-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      ' 5- 6-2000',
      47,
      7.269936,
      17,
      ' 8- 8-1986',
      1,
      135,
      '10-18-1980',
      4.750122,
      77,
      1.674802,
      20.172310,
      ' 4-21-1999',
      NULL,
      NULL,
      3,
      ' 9-26-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


