set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6805689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      '3',
      '0',
      '0',
      '1',
      '1',
      '3',
      '2',
      '0',
      '2',
      '2',
      '1',
      '3',
      '4',
      NULL,
      '2',
      '1',
      '0',
      '2',
      '1',
      NULL,
      NULL,
      '1',
      '',
      NULL,
      '',
      NULL,
      '1',
      '3',
      '3',
      '1',
      '',
      '',
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      '2',
      '0',
      '1',
      '3',
      '2',
      NULL,
      NULL,
      '21',
      55.750082,
      38,
      '2211222',
      NULL,
      NULL,
      0,
      NULL,
      '310220',
      5,
      ' 3-15-1992',
      '10-25-1988',
      255,
      68,
      22,
      5,
      16,
      8,
      14,
      1,
      NULL,
      16.428689,
      12,
      15.483566,
      40.678505,
      NULL,
      6.312447,
      11,
      29,
      0.353169,
      15,
      6,
      6,
      8,
      27.847559,
      4.041458,
      0,
      32.067298,
      19.850208,
      21,
      94.168651,
      1.831960,
      NULL,
      NULL,
      NULL,
      7.284086,
      35.291597,
      11,
      35.978388,
      180,
      '11-28-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      64,
      36.297891,
      19,
      10.909779,
      6.279737,
      NULL,
      ' 7-25-1980',
      1.507676,
      NULL,
      61,
      1.678770,
      NULL,
      20,
      NULL,
      1.490884,
      14.149107,
      NULL,
      NULL,
      NULL,
      '10- 9-1995',
      110.293006,
      82,
      41,
      7.656175,
      NULL,
      15.458793,
      NULL,
      67.374194,
      53,
      63.885534,
      NULL,
      35,
      ' 8- 6-1986',
      NULL,
      3,
      15.649813,
      54.513239,
      14,
      36,
      NULL,
      ' 1-16-1999',
      22.765600,
      0.093500,
      ' 0- 2-1979',
      1.603180,
      13.234535,
      11.428178,
      23,
      11.771265,
      4.401068,
      NULL,
      NULL,
      0,
      49,
      1,
      NULL,
      1.031935,
      9.724863,
      NULL,
      NULL,
      1,
      0,
      ' 2- 5-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      76,
      NULL,
      ' 0- 2-2003',
      NULL,
      NULL,
      NULL,
      27.954264,
      ' 9-18-1975',
      24,
      NULL,
      5.153278,
      NULL,
      ' 9-28-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      7,
      ' 6-26-1997',
      NULL,
      27,
      46.787581,
      NULL,
      0.076005,
      60.348246,
      ' 1-15-1977',
      0,
      NULL,
      3.740374,
      65,
      ' 2-26-1991',
      33.392978,
      1,
      NULL,
      ' 8- 5-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


