set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6805689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      '3',
      NULL,
      '1',
      '1',
      '4',
      '1',
      '3',
      '3',
      NULL,
      '4',
      '2',
      '3',
      '2',
      '4',
      '2',
      '3',
      '2',
      '3',
      '2',
      '3',
      '2',
      '4',
      NULL,
      '2',
      '',
      '2',
      '0',
      '1',
      '4',
      '2',
      '',
      '',
      '3',
      '4',
      NULL,
      '1',
      '0',
      '0',
      '4',
      '0',
      '2',
      '2',
      '2',
      '444',
      '10232324',
      18.360619,
      NULL,
      '3212041',
      3.517060,
      106.810076,
      0,
      NULL,
      '212430',
      5.338346,
      ' 8-21-2000',
      ' 2-25-1994',
      85,
      NULL,
      16.060759,
      17.689244,
      23,
      NULL,
      8.786934,
      NULL,
      10.888755,
      10.407905,
      17,
      4.911980,
      NULL,
      NULL,
      1,
      13,
      11,
      12,
      3.268471,
      NULL,
      4.830832,
      13,
      25.257985,
      2,
      NULL,
      0.432065,
      87,
      53,
      37.636772,
      97,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      49,
      20,
      14.562770,
      NULL,
      11,
      0.292151,
      '10-19-1982',
      1,
      1,
      181.270976,
      1.164972,
      1,
      39.767618,
      0.318860,
      0.452208,
      30,
      NULL,
      NULL,
      NULL,
      NULL,
      44.716980,
      102.597250,
      96.056545,
      69,
      73,
      45.111176,
      36,
      NULL,
      94,
      5,
      63.528824,
      47.711632,
      NULL,
      1,
      14.340715,
      10.994204,
      1,
      31.807211,
      36.430972,
      3,
      ' 2- 6-1984',
      7,
      11,
      ' 6-14-1990',
      11,
      17,
      0.306568,
      28,
      NULL,
      2,
      0.032346,
      6.252648,
      1.676308,
      14,
      NULL,
      1,
      6.422263,
      30,
      1,
      0.598409,
      1,
      0.890088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46,
      NULL,
      NULL,
      ' 6-29-1977',
      2.257116,
      4.886902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      ' 9- 3-1999',
      18.577952,
      8,
      23.073105,
      ' 7- 2-1996',
      0,
      NULL,
      ' 0-10-1980',
      3.358953,
      NULL,
      13.508394,
      98.444216,
      ' 5-20-1983',
      19.181753,
      0,
      83,
      ' 3-29-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


