set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9664424';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      '4',
      '0',
      '0',
      '3',
      '0',
      '1',
      '2',
      NULL,
      '1',
      '1',
      '0',
      '1',
      '3',
      '2',
      NULL,
      '3',
      '3',
      '0',
      '2',
      '0',
      '2',
      NULL,
      '',
      NULL,
      '',
      '3',
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      '',
      NULL,
      '4',
      '3',
      '0',
      '0',
      '4',
      '4',
      '3',
      '0',
      '2',
      '0',
      '202',
      '02301014',
      0.445264,
      NULL,
      '4144131',
      3.025399,
      1.901836,
      3,
      NULL,
      NULL,
      0,
      ' 8-13-1980',
      ' 4-28-1982',
      80,
      118,
      2.408443,
      4,
      18.527687,
      NULL,
      NULL,
      2.730152,
      0.217487,
      4.156502,
      14,
      3,
      11.309556,
      10,
      16,
      6.265831,
      1,
      8.180101,
      29.914706,
      13,
      58,
      14.819701,
      66.923973,
      5,
      NULL,
      5.327311,
      NULL,
      7.142097,
      163.565873,
      43.593543,
      NULL,
      ' 5-10-1982',
      24,
      21,
      8,
      21,
      128.620278,
      75,
      ' 4-25-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.410901,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0,
      12,
      4,
      1.896672,
      2.780161,
      NULL,
      NULL,
      49.667007,
      NULL,
      NULL,
      NULL,
      ' 1-11-1982',
      13.207613,
      21,
      9,
      NULL,
      26.216770,
      NULL,
      13.627094,
      10,
      3.820180,
      30,
      27,
      30,
      NULL,
      8.429386,
      0.486667,
      10.868954,
      30.001087,
      NULL,
      NULL,
      0.185254,
      ' 0- 2-1982',
      NULL,
      NULL,
      ' 5- 6-2001',
      NULL,
      12.475897,
      5,
      4.169206,
      NULL,
      3.387124,
      1,
      1.849069,
      1,
      1.456741,
      1,
      NULL,
      9,
      7,
      7.707672,
      NULL,
      NULL,
      0.880918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      '10-11-1986',
      NULL,
      ' 2- 9-1992',
      0,
      12.189891,
      ' 7- 3-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      7.052170,
      ' 5-19-2002',
      18.213110,
      28,
      29.820129,
      ' 5-21-1994',
      0,
      NULL,
      ' 2-28-1977',
      NULL,
      35.849353,
      7,
      5.738764,
      ' 9-20-1988',
      35,
      NULL,
      73.713923,
      '10-19-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


