set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9330628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '23231010',
      '42044423',
      '13124143',
      '33410032',
      '00401232',
      '11340034',
      '42131410',
      '42240040',
      NULL,
      '31230240',
      '11444000',
      '40143024',
      '41144011',
      '42414011',
      NULL,
      '30444033',
      '31300130',
      '14134121',
      '24200441',
      NULL,
      '11133201',
      '40412432',
      '12200111',
      '23141231',
      '04110342',
      '10220010',
      '10220434',
      '40443221',
      '11141034',
      NULL,
      '22314043',
      NULL,
      '14000240',
      '21203131',
      '00023404',
      '03041332',
      '20442413',
      '11304222',
      '22410330',
      '12304333',
      '22414402',
      '44220303',
      '02100311',
      '24330011',
      '411',
      '03',
      NULL,
      NULL,
      '3122210',
      3.765531,
      1,
      2,
      NULL,
      '143011',
      NULL,
      ' 4- 1-1974',
      '10-12-1983',
      4.030162,
      NULL,
      NULL,
      14.874274,
      29.531005,
      NULL,
      NULL,
      19.931091,
      16.303981,
      1.222373,
      43.269955,
      8,
      NULL,
      11,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      56.394477,
      20.894373,
      4.512464,
      18,
      1.812965,
      NULL,
      120.457417,
      67,
      18,
      165,
      NULL,
      ' 4-14-1981',
      38.800669,
      48,
      27,
      2,
      75.820211,
      95,
      ' 3-26-1992',
      1.907558,
      0.267187,
      4,
      1.187644,
      1.025225,
      3.564182,
      NULL,
      NULL,
      0,
      1,
      0.365526,
      1.065990,
      0,
      0.905930,
      1,
      NULL,
      2,
      0.833813,
      1,
      1.489420,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-25-1992',
      77.866034,
      7.253421,
      NULL,
      7.064620,
      13.277951,
      5,
      '10-19-1984',
      0,
      1,
      192,
      0.137619,
      0,
      67.411648,
      1.305073,
      2.895603,
      70.565729,
      NULL,
      NULL,
      NULL,
      ' 1-25-1986',
      36.978983,
      103,
      30,
      103,
      90.364169,
      18,
      NULL,
      139,
      2,
      NULL,
      28,
      41.359412,
      ' 6-19-1994',
      20.921511,
      7,
      32.443152,
      56,
      143,
      50,
      15.757767,
      '11- 4-2002',
      15,
      6.780417,
      NULL,
      2.732929,
      0,
      NULL,
      1,
      NULL,
      4.238140,
      1.264944,
      3.972804,
      NULL,
      45,
      1.608038,
      1,
      14,
      19.409856,
      0.428204,
      0.225050,
      2.932086,
      NULL,
      ' 5-24-1986',
      NULL,
      5.192631,
      NULL,
      ' 0-16-1992',
      NULL,
      12,
      '11-28-1997',
      NULL,
      NULL,
      NULL,
      33,
      ' 9-27-1986',
      10.235971,
      ' 5-20-1988',
      1.816590,
      NULL,
      ' 6-14-1990',
      118.405511,
      116,
      ' 1- 0-1989',
      10.996420,
      3.513902,
      '10-26-1979',
      NULL,
      NULL,
      NULL,
      0,
      1,
      20.091406,
      ' 3-23-1983',
      23,
      NULL,
      6,
      NULL,
      0,
      47.057464,
      ' 6-19-1978',
      15.318779,
      17.079908,
      23,
      19,
      ' 0-12-1976',
      35.088354,
      1,
      38.178320,
      ' 1-15-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13);
commit;
end;
/


