set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9330628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2214',
      '13333104',
      '21443032',
      '11031113',
      '14132310',
      '04342422',
      '00222340',
      '20310220',
      '10343423',
      '40301324',
      '41021320',
      NULL,
      '42344023',
      '10022144',
      '13002011',
      '24220141',
      '23023422',
      '42332340',
      '03214232',
      '13331322',
      '31221431',
      NULL,
      NULL,
      '20034120',
      '23321344',
      '23000240',
      '00213314',
      '22023231',
      '03400244',
      '31342103',
      NULL,
      '41312022',
      '10322403',
      NULL,
      '03413021',
      '14032044',
      '34434312',
      '23130434',
      '34404404',
      NULL,
      '10021024',
      '10220431',
      '34022011',
      '00210343',
      '21103032',
      NULL,
      NULL,
      1,
      6.548504,
      NULL,
      2,
      31.419471,
      1,
      NULL,
      '434044',
      3.391695,
      '11-25-1999',
      ' 4-26-1992',
      70,
      NULL,
      NULL,
      12.127309,
      35,
      14,
      28.587196,
      16,
      12,
      14,
      17,
      17,
      15,
      7,
      23,
      3,
      19.728217,
      NULL,
      12,
      NULL,
      7,
      4,
      NULL,
      8.929864,
      0.314567,
      NULL,
      187,
      29.247010,
      24.225129,
      NULL,
      43.847400,
      NULL,
      NULL,
      40,
      NULL,
      5.561418,
      49,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35,
      8.146281,
      24.559531,
      4.239159,
      2.534812,
      '11-21-1982',
      0,
      1,
      195.545624,
      0,
      0,
      26,
      NULL,
      0.834255,
      86.639309,
      NULL,
      NULL,
      NULL,
      ' 4- 7-1979',
      118.074844,
      3,
      58,
      68,
      15,
      NULL,
      67,
      63.333434,
      NULL,
      33,
      91.126661,
      51.246060,
      ' 3-19-1981',
      14,
      15.460429,
      10,
      NULL,
      NULL,
      NULL,
      5,
      ' 5- 0-1976',
      18,
      2,
      NULL,
      3.772273,
      1,
      10.103613,
      12.108783,
      14.351194,
      1,
      0,
      NULL,
      NULL,
      37.506111,
      3.521252,
      1,
      NULL,
      NULL,
      8.980140,
      8.120611,
      5,
      3.299360,
      ' 3-26-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      26.614041,
      2.764337,
      ' 5- 0-1989',
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6,
      8.497389,
      '10-29-1997',
      4,
      103.070949,
      ' 1- 7-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      20.124809,
      ' 6-22-1976',
      NULL,
      43,
      46,
      '11- 2-1992',
      0,
      16.456503,
      ' 9- 7-1987',
      14.165898,
      12.441566,
      NULL,
      33.959686,
      ' 7-14-1993',
      NULL,
      0.781574,
      80,
      ' 0-10-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


