set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9330628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4332',
      '43304330',
      '03104300',
      '42040411',
      '20414122',
      '13003420',
      NULL,
      '40140242',
      '24400111',
      '02311443',
      NULL,
      '11134130',
      '01344244',
      '23121431',
      NULL,
      '31323343',
      '44014232',
      '04000130',
      '42111024',
      '43204222',
      '40143102',
      '41001243',
      '03121222',
      '33224202',
      '10032140',
      '00112124',
      '12210322',
      '34034312',
      '44313331',
      '31041244',
      NULL,
      NULL,
      '44021123',
      '01424242',
      '23113201',
      '14210412',
      '14133231',
      '01234044',
      '11110100',
      '24332214',
      '01223401',
      '42330422',
      '23114331',
      '03113303',
      '02231241',
      '020',
      '12',
      30,
      NULL,
      '0132242',
      NULL,
      6,
      NULL,
      NULL,
      '113001',
      NULL,
      '11-18-1978',
      NULL,
      77,
      53,
      6.769016,
      1.842115,
      30,
      19.402387,
      NULL,
      7,
      9.857818,
      2,
      24.813654,
      15.160885,
      39.253105,
      3.552724,
      NULL,
      14,
      31.054951,
      NULL,
      NULL,
      22.728675,
      60,
      17,
      NULL,
      8.943969,
      0,
      116.895665,
      102,
      NULL,
      NULL,
      43,
      192.602829,
      ' 1- 0-1987',
      24,
      NULL,
      19,
      30.751538,
      127.952070,
      208,
      ' 3-14-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18.843757,
      12,
      3,
      4.358796,
      5,
      ' 1-29-1987',
      NULL,
      1,
      65,
      NULL,
      NULL,
      NULL,
      1.478416,
      0,
      90.306421,
      NULL,
      NULL,
      NULL,
      NULL,
      100.868149,
      41,
      8.893420,
      NULL,
      51.401435,
      76.662574,
      68,
      12.278807,
      NULL,
      40.719920,
      NULL,
      52,
      ' 7-27-2002',
      1,
      4.789446,
      NULL,
      24,
      13,
      NULL,
      11,
      ' 5- 1-1986',
      10.223317,
      21,
      '10- 0-1999',
      NULL,
      16.324896,
      4.262146,
      19.652128,
      22.900512,
      1,
      NULL,
      1,
      0,
      NULL,
      0.830529,
      1,
      NULL,
      22.695268,
      0,
      0,
      NULL,
      0,
      ' 9- 8-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      2.277095,
      0.852367,
      ' 4-10-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 2-1978',
      0,
      ' 8-16-1984',
      6,
      NULL,
      NULL,
      57,
      51,
      ' 0- 3-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      24,
      ' 7- 4-1976',
      12.985808,
      NULL,
      17,
      NULL,
      1.007555,
      43.330608,
      ' 4-15-1978',
      0.354055,
      4,
      NULL,
      3,
      ' 9- 7-1981',
      25.119214,
      0.063872,
      3.320602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


