set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9330628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      '2',
      NULL,
      '2',
      '0',
      '1',
      NULL,
      '3',
      '4',
      '2',
      '2',
      '1',
      '4',
      '3',
      NULL,
      '0',
      NULL,
      '2',
      NULL,
      '4',
      '2',
      '2',
      '4',
      '',
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      '3',
      '4',
      '',
      '',
      '0',
      NULL,
      '4',
      '1',
      '1',
      NULL,
      '0',
      '2',
      '2',
      '3',
      NULL,
      '402',
      '42342141',
      53.558297,
      5,
      '2310422',
      2.137973,
      70.181447,
      0,
      NULL,
      NULL,
      4,
      NULL,
      '10-24-1985',
      86.414954,
      45,
      8.043732,
      11,
      10.085264,
      3.319789,
      48.566477,
      6.292341,
      9.335211,
      9.472215,
      29,
      21,
      17,
      18.994229,
      20,
      10,
      23.552837,
      22.141185,
      25,
      6,
      NULL,
      1,
      36,
      14.220035,
      NULL,
      94,
      143.357477,
      NULL,
      111,
      75.918351,
      159,
      '11-24-1992',
      38,
      42,
      19.863626,
      NULL,
      20,
      12,
      ' 8- 8-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      64,
      14,
      4,
      2,
      2,
      1,
      NULL,
      1,
      1,
      29,
      NULL,
      1,
      14,
      0.872657,
      1.902525,
      19.082052,
      NULL,
      NULL,
      NULL,
      NULL,
      54.590254,
      NULL,
      87,
      10.681289,
      77,
      60.933549,
      63.048066,
      93.082215,
      87,
      8,
      NULL,
      NULL,
      ' 8- 5-1975',
      NULL,
      11.048120,
      32.996137,
      NULL,
      115.759003,
      137.213682,
      5,
      NULL,
      17,
      5,
      ' 4- 2-1999',
      2,
      8,
      6.258557,
      18,
      5.374873,
      0.028570,
      0,
      NULL,
      0.084246,
      NULL,
      0.904466,
      0.070776,
      1.554688,
      12,
      0.145068,
      2.142176,
      NULL,
      2,
      ' 3- 2-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      5.286555,
      2.247996,
      ' 1-18-1979',
      NULL,
      NULL,
      NULL,
      52.509708,
      ' 7-21-1982',
      33,
      '10-20-1980',
      NULL,
      12.266285,
      ' 8-21-1994',
      35.854687,
      NULL,
      ' 0-24-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      ' 8- 2-1997',
      16,
      NULL,
      NULL,
      ' 0-22-1979',
      1.922789,
      NULL,
      ' 1-28-1976',
      14.109329,
      19.547639,
      11.942736,
      12.143108,
      NULL,
      42.778194,
      1.441910,
      54.738360,
      ' 8-24-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


