set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9330628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      '3',
      '4',
      '3',
      '1',
      '4',
      '1',
      NULL,
      '0',
      NULL,
      '3',
      '4',
      '2',
      '0',
      '0',
      '4',
      '4',
      NULL,
      '4',
      NULL,
      '4',
      NULL,
      NULL,
      '',
      '4',
      '',
      '0',
      '1',
      '0',
      '0',
      '2',
      '',
      NULL,
      '0',
      '3',
      '4',
      '0',
      '1',
      '4',
      '1',
      '3',
      '0',
      '1',
      '0',
      '422',
      '41244410',
      60,
      78.567339,
      NULL,
      2,
      4,
      2,
      0,
      '024110',
      0.465826,
      ' 1-12-1996',
      ' 0-15-1999',
      190.857563,
      75,
      10,
      13,
      17.013351,
      NULL,
      45,
      25,
      21.947791,
      23.519202,
      28,
      12,
      27,
      20.833362,
      NULL,
      16.855529,
      15.011907,
      2,
      17,
      2,
      NULL,
      6,
      98.904242,
      16,
      0,
      140,
      NULL,
      96.154133,
      13.707663,
      NULL,
      153,
      ' 5- 3-1980',
      50.620964,
      61.622072,
      NULL,
      37,
      72,
      124.667344,
      ' 5-11-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      60.393473,
      11.461906,
      4,
      6.955729,
      1,
      6,
      ' 1-22-1976',
      1.731882,
      NULL,
      99.304816,
      NULL,
      1,
      103.336483,
      1.919364,
      3.762732,
      88.512339,
      NULL,
      NULL,
      NULL,
      ' 8-16-1994',
      109.569838,
      54,
      86.909899,
      100,
      63.730872,
      74.511441,
      93,
      40.306220,
      NULL,
      NULL,
      23,
      NULL,
      '11-17-2003',
      27,
      17,
      5,
      43.518723,
      56.234312,
      54.356536,
      NULL,
      ' 4-15-1983',
      28.175201,
      NULL,
      ' 4-21-1991',
      8,
      16,
      5.976734,
      2.484155,
      21.669364,
      0.360544,
      1.575716,
      3.822789,
      1.355820,
      89.250159,
      1,
      5.040881,
      21.819103,
      21.632676,
      4.384785,
      0.042085,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40.191265,
      4.847761,
      ' 4-17-1999',
      NULL,
      NULL,
      NULL,
      51,
      '10-18-1990',
      40.095480,
      ' 4- 7-1995',
      12,
      0.609584,
      ' 4-18-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      13.706361,
      ' 5-22-1986',
      NULL,
      12.741234,
      30,
      NULL,
      0.287315,
      85.551765,
      ' 1- 2-2000',
      9.314073,
      NULL,
      12.177689,
      6,
      NULL,
      23.004843,
      1,
      77,
      '11-21-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


