set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9101607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2214',
      '41201210',
      '21142200',
      NULL,
      NULL,
      NULL,
      '42311104',
      '11102331',
      '02224242',
      '11024330',
      NULL,
      '43321012',
      '14000204',
      '40304213',
      '34024124',
      '24201401',
      '04434000',
      '23210234',
      '12344432',
      '30343401',
      '22320140',
      '24320103',
      '43042114',
      NULL,
      '31411013',
      '12124211',
      '41300313',
      '30201141',
      '41134004',
      NULL,
      '33031312',
      '41132242',
      NULL,
      '40311133',
      NULL,
      '31440404',
      '13341231',
      NULL,
      '20111111',
      NULL,
      '30443442',
      NULL,
      '21044202',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '0403204',
      1,
      0.115132,
      NULL,
      NULL,
      '004443',
      3,
      ' 1-24-1978',
      '11-19-1978',
      16,
      NULL,
      6,
      7,
      NULL,
      11,
      NULL,
      3.811880,
      NULL,
      NULL,
      NULL,
      1.717659,
      10,
      13.384877,
      19,
      11,
      7,
      5.334244,
      17.031549,
      NULL,
      2.656496,
      3,
      NULL,
      13.273904,
      NULL,
      86,
      6.574194,
      51.150646,
      104,
      63.054935,
      NULL,
      ' 7-22-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.301008,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.039990,
      0,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 8-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-10-1985',
      99.983668,
      99.682047,
      91.498036,
      77.882061,
      46,
      1,
      117,
      110,
      23,
      115.149063,
      54,
      67.100751,
      NULL,
      NULL,
      1,
      1.923930,
      NULL,
      41.078587,
      67,
      4.510284,
      '10- 7-1975',
      3,
      1,
      ' 4-18-1989',
      2.946162,
      7.192228,
      3,
      NULL,
      5,
      7.736733,
      NULL,
      18.827189,
      NULL,
      79.695835,
      0.384857,
      NULL,
      21.069809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-12-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      19.725776,
      1.112921,
      ' 5-22-1989',
      0.845218,
      152.507141,
      ' 4-12-1987',
      2.746099,
      16,
      18.636469,
      31.730837,
      ' 5-14-1983',
      64,
      1,
      53.253920,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      135,
      0.652995,
      62.499960,
      12,
      68,
      50,
      11,
      10,
      16.195197,
      9.838813,
      5.254457,
      0,
      9,
      16.461761,
      2.126317,
      1.469291,
      40.898558,
      2.983471,
      NULL,
      NULL,
      4.943152,
      NULL,
      NULL,
      14.859068,
      NULL,
      50,
      0.730070,
      44,
      1,
      1.416347,
      1.322438,
      NULL,
      1,
      1,
      NULL,
      14,
      NULL,
      14.809165,
      62.888055,
      12.650892,
      3,
      0.061045,
      NULL,
      1,
      8.066112,
      2,
      7.716868,
      0,
      28.198238,
      NULL,
      78,
      1.366083,
      2,
      71,
      31,
      12.836207,
      25,
      16,
      31.151797,
      16,
      NULL,
      0,
      0,
      0,
      0.903521,
      NULL,
      0,
      1.188080,
      NULL,
      NULL,
      NULL,
      '10-29-1982',
      '11-13-1992',
      ' 9-28-1981',
      ' 8- 3-1978',
      ' 7-14-1997',
      '10- 5-2003',
      NULL);
commit;
end;
/


