set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9101607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4212',
      '40424033',
      NULL,
      '20414022',
      '01140024',
      '12100241',
      '20410211',
      '03300323',
      '01131313',
      '40220230',
      NULL,
      '22412340',
      NULL,
      NULL,
      '22331244',
      '02132201',
      '44303102',
      '14231011',
      '12412030',
      '04404441',
      '00432212',
      '13324202',
      '12143244',
      NULL,
      '42000130',
      NULL,
      '11402204',
      '13101020',
      '32010422',
      '24022141',
      NULL,
      '03130444',
      '14414041',
      '34003303',
      '14200340',
      '23311114',
      NULL,
      '30234101',
      NULL,
      '03312034',
      '42344100',
      '00004113',
      '04313413',
      '33011044',
      '33000320',
      NULL,
      '33',
      NULL,
      9.039915,
      '1003314',
      NULL,
      51.921934,
      NULL,
      NULL,
      '034240',
      0,
      ' 6- 8-1977',
      ' 8- 4-1993',
      69.445771,
      NULL,
      23,
      NULL,
      14,
      7,
      39.505083,
      13,
      17,
      11,
      26,
      6,
      25.320047,
      7,
      7.160943,
      NULL,
      5,
      16.823998,
      39,
      4.791915,
      38,
      8,
      25.834586,
      14.110422,
      1,
      NULL,
      142,
      22,
      158.597279,
      156,
      9,
      NULL,
      28,
      9.133005,
      20.827152,
      NULL,
      134.696160,
      NULL,
      ' 0-14-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      85,
      11.616839,
      4.568937,
      11.844799,
      3.013045,
      1.728382,
      ' 0-27-1975',
      0.985114,
      0,
      16.425567,
      5,
      1.780708,
      130,
      0,
      0,
      19.358820,
      NULL,
      NULL,
      NULL,
      ' 6-25-1990',
      64,
      60.534037,
      19.347862,
      41,
      81,
      15.379891,
      24.267633,
      70.227735,
      NULL,
      41,
      46,
      32.286152,
      ' 1- 5-1984',
      23.774778,
      NULL,
      4.239311,
      68.593766,
      14.037976,
      101.347897,
      11,
      ' 3-23-1988',
      0,
      NULL,
      ' 9- 9-1982',
      6,
      8.506222,
      11,
      2.208404,
      21.947052,
      10.295979,
      0.994366,
      25,
      1.239156,
      62.144643,
      5.436427,
      2.568898,
      18.830651,
      NULL,
      1.631893,
      0,
      1.293633,
      1.155895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      93.155770,
      0.426528,
      ' 0-28-1979',
      NULL,
      NULL,
      NULL,
      2,
      ' 9- 4-1989',
      9,
      ' 4- 7-1997',
      NULL,
      1.140576,
      ' 8- 2-1995',
      53,
      87.382350,
      ' 3-14-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      ' 5- 7-1983',
      0,
      22,
      NULL,
      NULL,
      0,
      21,
      ' 7- 2-1975',
      5.106767,
      0,
      4.773386,
      11,
      ' 9- 0-1981',
      NULL,
      0,
      57,
      '11-17-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


