set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9101607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      '1',
      '2',
      '4',
      NULL,
      '3',
      '3',
      '0',
      '1',
      '4',
      '0',
      '0',
      '2',
      NULL,
      '3',
      NULL,
      '1',
      NULL,
      '2',
      '3',
      '2',
      '2',
      '0',
      '',
      '4',
      '',
      '0',
      '1',
      NULL,
      '0',
      '0',
      '',
      '',
      '2',
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      '2',
      NULL,
      '3',
      NULL,
      '0',
      '114',
      '14201320',
      7.051231,
      12,
      NULL,
      2,
      20,
      2,
      NULL,
      '130434',
      5,
      '11-13-1996',
      NULL,
      56,
      13,
      2.929699,
      9,
      4,
      19.467718,
      59.413501,
      21.408913,
      NULL,
      15,
      16.065709,
      4.229737,
      36.565330,
      NULL,
      11.677129,
      6.536105,
      NULL,
      12.791724,
      17.097758,
      13,
      NULL,
      3,
      59,
      13,
      NULL,
      83,
      69,
      41.841362,
      57.754582,
      3,
      53,
      ' 7-27-1989',
      41.675315,
      49.665691,
      0.271274,
      29,
      61.966771,
      NULL,
      ' 4-16-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      102.756194,
      NULL,
      12.578292,
      12.919830,
      5.719375,
      4.645103,
      ' 3- 2-1981',
      0,
      1,
      NULL,
      1.036409,
      3,
      40.193056,
      1.883734,
      5.301493,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 0-1994',
      45,
      1,
      NULL,
      43.284019,
      64,
      59.744807,
      100,
      NULL,
      26,
      NULL,
      13,
      62.988122,
      '11-13-1999',
      1.817787,
      3.450522,
      5,
      18.843942,
      19,
      8.357905,
      2,
      ' 4-28-1974',
      4.403184,
      16,
      ' 3-18-2000',
      8.231278,
      3,
      10,
      4.929749,
      23,
      NULL,
      0,
      8.329183,
      1,
      NULL,
      1,
      0.059216,
      NULL,
      NULL,
      1,
      1.467950,
      NULL,
      0.423875,
      ' 6-10-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      3.128674,
      16,
      ' 5-27-1991',
      NULL,
      NULL,
      NULL,
      19.133692,
      ' 6-26-1998',
      NULL,
      NULL,
      7.088932,
      11,
      ' 0-28-1991',
      12.225831,
      69.722464,
      ' 5- 8-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.251894,
      NULL,
      15,
      2,
      1,
      ' 9-14-1996',
      0.251645,
      71.614770,
      ' 9-25-1974',
      5.666957,
      3,
      4,
      33.912804,
      ' 5-14-1999',
      44.062931,
      1,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


