set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9101607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      '1',
      NULL,
      '0',
      '1',
      '4',
      '4',
      '1',
      '1',
      '3',
      '4',
      '1',
      NULL,
      '0',
      '3',
      '4',
      '3',
      '0',
      NULL,
      '2',
      '3',
      '1',
      '0',
      '',
      NULL,
      NULL,
      '0',
      '0',
      '2',
      '3',
      '1',
      NULL,
      '',
      NULL,
      '4',
      '3',
      NULL,
      '0',
      '2',
      '3',
      '2',
      '2',
      '4',
      '3',
      '120',
      '41244233',
      62.156127,
      23.795250,
      '0103302',
      1,
      36,
      0,
      0,
      '220042',
      0.992613,
      ' 3- 3-1999',
      NULL,
      96.574491,
      124.872448,
      19.815350,
      NULL,
      7,
      1.027531,
      21.677360,
      2.151667,
      10,
      21,
      2.153348,
      3.487264,
      36,
      20.310014,
      19,
      17.842896,
      21,
      3.840925,
      27.230391,
      4.068878,
      9.520872,
      NULL,
      39.462170,
      12,
      1.406477,
      NULL,
      NULL,
      NULL,
      NULL,
      24.075278,
      107.021670,
      '11-24-1998',
      41.248786,
      40,
      27.427206,
      27.773000,
      103.253480,
      154.881004,
      ' 4-14-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.733618,
      NULL,
      3.438124,
      0.764501,
      0,
      NULL,
      0.762423,
      4.656209,
      23,
      0,
      NULL,
      106.323136,
      NULL,
      1,
      98,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      73,
      35,
      NULL,
      5.188737,
      0,
      NULL,
      NULL,
      82,
      NULL,
      48.656908,
      87,
      NULL,
      11.077073,
      11.368737,
      10,
      68,
      8.903904,
      52,
      3,
      ' 6-15-1974',
      NULL,
      NULL,
      NULL,
      7.925791,
      7.213680,
      NULL,
      4.097413,
      7,
      1,
      NULL,
      17,
      1,
      23.477206,
      2.979782,
      0.029217,
      9,
      9.110784,
      0,
      1.840921,
      0,
      0.939648,
      ' 8- 5-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      22.575157,
      4,
      ' 1-13-1995',
      NULL,
      NULL,
      NULL,
      58.205416,
      ' 2- 4-1978',
      23.986875,
      '10-23-1992',
      1.442293,
      NULL,
      NULL,
      148.246695,
      87.934372,
      ' 0-18-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      55.369141,
      10,
      20.194922,
      NULL,
      NULL,
      73.009917,
      NULL,
      NULL,
      15.556075,
      NULL,
      2,
      NULL,
      17.510783,
      1,
      99.593970,
      ' 5- 2-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


