set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9101607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1300',
      '14402222',
      '34210241',
      '41004212',
      '22002040',
      '00121424',
      '12214333',
      '43134133',
      NULL,
      '42430130',
      '30330030',
      '21021323',
      NULL,
      '33223311',
      '33101314',
      '22344033',
      NULL,
      '40002212',
      '32103223',
      '02000403',
      '23111334',
      '12012424',
      '13004102',
      '14124013',
      '42313424',
      NULL,
      '43424423',
      '02212221',
      '21120214',
      '32421142',
      '34134104',
      '41303141',
      '14200402',
      '22020112',
      NULL,
      '23433031',
      '23423204',
      '01444232',
      '21014332',
      '21220213',
      '02413413',
      '41414030',
      '23214003',
      '33332032',
      '42020114',
      '230',
      '20',
      NULL,
      NULL,
      '2112224',
      5,
      0,
      1,
      NULL,
      NULL,
      1.042882,
      '11- 1-1980',
      '10-21-1988',
      33,
      NULL,
      35,
      7,
      NULL,
      3,
      108.767773,
      9,
      4,
      17.190170,
      10,
      8,
      7.544724,
      NULL,
      5.870759,
      12.685955,
      NULL,
      2,
      NULL,
      9.152525,
      1,
      6,
      61.528717,
      8,
      NULL,
      78,
      188,
      69.890448,
      NULL,
      188.342791,
      NULL,
      ' 7-27-1995',
      11,
      40.009518,
      6,
      8,
      42.574857,
      NULL,
      ' 7-17-1987',
      3.893079,
      1,
      5.782798,
      5,
      4.696855,
      0,
      7,
      3,
      1.986571,
      0,
      3.609991,
      0.030294,
      0,
      3,
      NULL,
      0.670513,
      NULL,
      NULL,
      0.038880,
      3.289884,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 6-1981',
      NULL,
      31,
      NULL,
      4.416281,
      15,
      2,
      NULL,
      1,
      1.273909,
      146,
      1,
      1,
      102.773595,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      ' 7-22-1991',
      82,
      55.810597,
      61.882815,
      69,
      47.266955,
      NULL,
      20,
      NULL,
      11,
      48,
      13.405385,
      84,
      ' 7-12-1986',
      10,
      8.874207,
      25.495961,
      54,
      42.134164,
      NULL,
      4,
      NULL,
      5.851503,
      4.714935,
      ' 5- 2-1979',
      7,
      10.645783,
      5,
      NULL,
      NULL,
      1,
      1,
      15,
      0.768094,
      47.382063,
      3.948922,
      NULL,
      0.662040,
      29.686927,
      1,
      0,
      NULL,
      1.353542,
      NULL,
      1,
      4.985407,
      3.050706,
      ' 4- 0-1977',
      13.274823,
      156,
      ' 0-10-2003',
      14.588713,
      11,
      ' 5-10-1977',
      36.073984,
      ' 4- 6-1981',
      39,
      ' 2- 2-1978',
      1,
      2,
      NULL,
      NULL,
      82.800869,
      ' 9-12-1976',
      4.230127,
      11.233193,
      ' 8-27-1986',
      NULL,
      5.483447,
      NULL,
      NULL,
      NULL,
      12.718731,
      '11- 6-1978',
      62.515340,
      12.819231,
      NULL,
      ' 3- 5-1997',
      1.097548,
      61.379426,
      ' 0- 8-1980',
      NULL,
      1.569061,
      NULL,
      NULL,
      ' 6-16-1979',
      NULL,
      1,
      58.175240,
      ' 8-10-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12);
commit;
end;
/


