set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8917621';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3014',
      NULL,
      '04244122',
      NULL,
      '22200241',
      '04212323',
      NULL,
      '30344140',
      '31120101',
      '14341222',
      '12223140',
      '23333313',
      '03132240',
      '20214201',
      NULL,
      '31212002',
      '33343302',
      '43034332',
      NULL,
      NULL,
      '22203433',
      '40212102',
      '24004033',
      '02130230',
      '11233210',
      '30014444',
      '13303043',
      NULL,
      '34340301',
      '04102114',
      '13443023',
      '42414240',
      '01122424',
      '04444441',
      '10231021',
      '24422311',
      '10212434',
      '33023231',
      '14430003',
      '40404231',
      '03003440',
      '30204012',
      NULL,
      NULL,
      '22044030',
      '202',
      '42',
      NULL,
      NULL,
      '4001142',
      1.440484,
      0.438912,
      3,
      NULL,
      '123121',
      1,
      ' 0-28-1975',
      ' 6-25-2001',
      93,
      NULL,
      21.876424,
      3,
      NULL,
      9.838897,
      75,
      NULL,
      19.605808,
      1,
      18,
      NULL,
      NULL,
      18,
      9.012171,
      20,
      NULL,
      11,
      36.087032,
      4.742033,
      8.643693,
      2,
      31,
      14,
      0.081044,
      55,
      4.409805,
      2,
      NULL,
      124.227914,
      161.340959,
      '10- 8-1999',
      NULL,
      49,
      6.608986,
      31.797621,
      162,
      230,
      NULL,
      0.162097,
      2.973471,
      1.965065,
      NULL,
      1.705073,
      0,
      1.126982,
      1.171706,
      0.507165,
      1.740425,
      1.356214,
      0.048016,
      0.103483,
      0.946736,
      1,
      0,
      NULL,
      1.343117,
      1.249144,
      1.932744,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-17-1982',
      33.144912,
      40,
      15.217301,
      NULL,
      12,
      5,
      ' 1-26-1979',
      0.064564,
      1.112429,
      154.845352,
      0,
      NULL,
      75,
      1,
      0.627135,
      68,
      0,
      1.096927,
      84.552421,
      '11-19-1989',
      85.389425,
      6.202495,
      91.147239,
      NULL,
      51,
      81,
      NULL,
      23,
      61.395733,
      46,
      NULL,
      47,
      ' 3- 9-1980',
      23,
      18,
      NULL,
      68,
      25,
      NULL,
      NULL,
      NULL,
      1,
      11.595165,
      ' 9-18-2002',
      8.036805,
      5.195160,
      7,
      27.173822,
      4,
      0.301878,
      0,
      23,
      1.330262,
      136.486448,
      1.369502,
      1.161513,
      1,
      17.737758,
      0.858010,
      NULL,
      1,
      1,
      ' 1-13-2002',
      8.782403,
      0,
      1.139523,
      '11-13-1998',
      31.100870,
      5.714597,
      '10- 8-1974',
      16,
      8.539777,
      ' 1-29-1992',
      46,
      '11-17-1982',
      NULL,
      '10-27-1992',
      NULL,
      1.240015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.908260,
      '10- 8-1976',
      0,
      10.956253,
      ' 8-17-1985',
      3,
      2,
      20.232361,
      ' 7-23-1987',
      26.578898,
      19,
      10.071745,
      ' 2-11-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4);
commit;
end;
/


