set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9133722';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2210',
      NULL,
      '40344240',
      '23303001',
      NULL,
      NULL,
      '43343333',
      '21312330',
      NULL,
      '03220343',
      '30340121',
      '11330310',
      '23430003',
      '21314432',
      '40422402',
      '03343311',
      NULL,
      '41402323',
      NULL,
      '10020123',
      '24223100',
      '14211411',
      '23003333',
      NULL,
      NULL,
      '30020134',
      '10012300',
      '44231013',
      NULL,
      '10032224',
      '01443100',
      '44320424',
      '14131214',
      '24000123',
      '41124012',
      '20103234',
      '31022001',
      '23032044',
      '12102302',
      '22023034',
      '43223241',
      '20202342',
      '01404024',
      '23113022',
      '24242312',
      '',
      '',
      NULL,
      NULL,
      '4300140',
      3.230009,
      1,
      NULL,
      NULL,
      '341243',
      2,
      ' 6-24-1993',
      ' 0-18-1989',
      36,
      NULL,
      0.005782,
      3,
      NULL,
      NULL,
      87.653144,
      15.750713,
      NULL,
      16,
      15.558465,
      1.755287,
      7.008044,
      6,
      NULL,
      4,
      38,
      NULL,
      79,
      NULL,
      5.214410,
      8,
      45.735951,
      12.840704,
      NULL,
      103.288748,
      151.361382,
      8.436260,
      74,
      224.938063,
      83,
      '11-27-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.168891,
      3.950082,
      0.361435,
      0.659559,
      NULL,
      NULL,
      NULL,
      NULL,
      0.236336,
      1.963421,
      NULL,
      0,
      0,
      0.156565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-19-1993',
      NULL,
      NULL,
      5,
      1,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-21-2000',
      84.488315,
      13,
      45,
      32,
      101.418644,
      12,
      2.497797,
      35,
      55.202220,
      87.534288,
      NULL,
      81,
      NULL,
      8,
      17.565734,
      7.241840,
      37.177326,
      27.215253,
      60.645832,
      2,
      '10-28-1989',
      10,
      NULL,
      '11-17-1985',
      3.345857,
      11.357016,
      5.210219,
      18.895609,
      12,
      0,
      NULL,
      8.738997,
      NULL,
      NULL,
      0.263707,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 2-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      65.327676,
      21.644892,
      5.609417,
      '10-10-1980',
      0,
      22.180831,
      ' 6-12-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      0.757109,
      NULL,
      53.930792,
      128.011074,
      2.005876,
      1,
      1.591609,
      NULL,
      1,
      74,
      NULL,
      1.586555,
      78.027801,
      1.483798,
      2,
      118,
      NULL,
      1.285924,
      72.695886,
      0,
      7.425000,
      22.229680,
      18.458420,
      NULL,
      NULL,
      1.314730,
      77,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.205390,
      NULL,
      NULL,
      NULL,
      89.063248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.358052,
      33,
      0.410805,
      2,
      71,
      4,
      NULL,
      NULL,
      NULL,
      59,
      NULL,
      NULL,
      11.685305,
      0,
      0,
      NULL,
      0.372200,
      0.223241,
      1,
      1.034552,
      79.963127,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-29-1976',
      NULL,
      ' 6- 9-1988',
      NULL);
commit;
end;
/


