set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9133722';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '04141042',
      NULL,
      '42424322',
      NULL,
      '23134034',
      '04041403',
      '42301001',
      '23421134',
      '44434111',
      '14012004',
      NULL,
      '13031143',
      NULL,
      '32144222',
      '23230232',
      NULL,
      '10344432',
      '02231042',
      '13310421',
      '31230303',
      '44234100',
      NULL,
      '31221112',
      NULL,
      '10310044',
      '01444423',
      '24321314',
      '10342310',
      NULL,
      '34431243',
      '12404313',
      '24101201',
      NULL,
      '40412222',
      '22402141',
      '34021214',
      '31120313',
      '21434124',
      '23023303',
      '12344123',
      '10413422',
      '32040422',
      '24120311',
      '30240032',
      '442',
      '23',
      NULL,
      NULL,
      '1143243',
      1,
      NULL,
      0,
      NULL,
      '331342',
      NULL,
      ' 8-12-1995',
      NULL,
      51,
      NULL,
      36,
      19.894339,
      7,
      19.247007,
      50,
      3,
      25,
      27,
      NULL,
      6,
      29.516125,
      NULL,
      39,
      23,
      13,
      1.089551,
      68.046982,
      NULL,
      19,
      NULL,
      NULL,
      8.175331,
      NULL,
      48,
      22,
      49,
      196,
      NULL,
      104.170639,
      ' 7-25-1999',
      40.291153,
      20.133713,
      35.177261,
      39.663396,
      211.243154,
      65,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0.599935,
      NULL,
      3.516427,
      NULL,
      0,
      1.500179,
      3.130790,
      1,
      1,
      0,
      0,
      1,
      0.227233,
      1.189707,
      1.315357,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 7-1974',
      44.707975,
      13,
      1,
      NULL,
      4.565714,
      NULL,
      ' 1-20-2000',
      NULL,
      1.822755,
      10,
      1,
      1.438316,
      56.027846,
      1.173460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-29-1977',
      14.069180,
      33,
      NULL,
      62.158070,
      92,
      69.561531,
      NULL,
      NULL,
      26.854831,
      7.181043,
      99,
      36.154415,
      NULL,
      15,
      22.789997,
      18.511721,
      15,
      80,
      122,
      7,
      '10-19-1996',
      20.722669,
      NULL,
      NULL,
      7,
      11,
      12,
      6,
      6,
      7.794626,
      NULL,
      NULL,
      1,
      11,
      3,
      NULL,
      11.077788,
      11.962962,
      NULL,
      2,
      3,
      1.264798,
      ' 2-18-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      74.872181,
      10,
      '11- 9-1998',
      NULL,
      NULL,
      NULL,
      56.874499,
      ' 3-25-1974',
      NULL,
      ' 4- 4-2003',
      6.177200,
      1,
      ' 5-28-1981',
      74,
      69.501235,
      ' 3- 4-1984',
      NULL,
      6.629642,
      '11-11-2001',
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      17,
      ' 3-20-1998',
      44.704406,
      NULL,
      35.606044,
      ' 1-24-1983',
      1.840781,
      4.400077,
      ' 6-22-1986',
      NULL,
      46.972547,
      7,
      47,
      NULL,
      37,
      0,
      167.432009,
      ' 2-20-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


