set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9133722';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3301',
      '04204432',
      NULL,
      '30234014',
      '20340203',
      NULL,
      '42413023',
      '34004440',
      '10213340',
      '43300442',
      '00132114',
      '14400233',
      '04223443',
      '43420100',
      NULL,
      NULL,
      '34101000',
      '23341143',
      '12132314',
      '12203423',
      '12322323',
      NULL,
      '02112432',
      '13003113',
      '41441143',
      '02322312',
      '01400333',
      '33200111',
      '44100000',
      '41422411',
      '33123204',
      '33241022',
      '20130411',
      '42331413',
      '01340401',
      NULL,
      '44213001',
      '02341011',
      '14103314',
      NULL,
      '14122134',
      '01133303',
      '43102400',
      '21134213',
      '04043312',
      NULL,
      '03',
      18.569364,
      1.650543,
      '4400424',
      NULL,
      9.441243,
      1,
      NULL,
      '434242',
      0.150476,
      ' 1- 4-1978',
      '11- 6-1990',
      25.397301,
      59,
      25,
      15.374422,
      33.734481,
      0.410716,
      53.363311,
      NULL,
      14.864124,
      4,
      22.308405,
      3.386423,
      25.013722,
      NULL,
      16.679020,
      16.413659,
      NULL,
      NULL,
      4,
      29.283279,
      23,
      17.858431,
      94.115003,
      0.446765,
      1.770413,
      101.554833,
      90,
      33.208733,
      158,
      150.912874,
      NULL,
      ' 8- 0-1987',
      24,
      18.540175,
      25.769520,
      NULL,
      194,
      19,
      ' 6-15-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      28,
      10,
      NULL,
      5.445846,
      NULL,
      3,
      ' 5-27-1981',
      0,
      1.706209,
      88,
      3.724579,
      0,
      15.580877,
      1.303830,
      5,
      62.062523,
      NULL,
      NULL,
      NULL,
      ' 5- 6-1981',
      69.647722,
      40,
      5,
      81.671593,
      39,
      4.295117,
      62,
      24.623960,
      NULL,
      17,
      79,
      NULL,
      ' 6-13-1990',
      0,
      NULL,
      NULL,
      6.363485,
      NULL,
      NULL,
      NULL,
      '10-23-1987',
      NULL,
      5,
      ' 2-10-1999',
      9,
      5.173727,
      14.902063,
      13.244823,
      24.377916,
      NULL,
      0,
      6,
      1,
      29.030308,
      3.412230,
      3,
      3,
      NULL,
      4.928938,
      4,
      0,
      1,
      ' 6- 4-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      NULL,
      ' 3-22-1980',
      NULL,
      NULL,
      NULL,
      51.783614,
      ' 4-24-2001',
      NULL,
      ' 4-29-1989',
      12.755323,
      7,
      NULL,
      87,
      NULL,
      ' 7- 4-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      3,
      ' 5-28-1981',
      NULL,
      14.871689,
      17.084661,
      '11-10-1991',
      1,
      NULL,
      ' 0-12-1993',
      1,
      NULL,
      11.754424,
      NULL,
      ' 5-26-1978',
      52,
      1.706570,
      37,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


