set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9133722';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      '3',
      '4',
      '0',
      NULL,
      '4',
      NULL,
      NULL,
      '0',
      '3',
      '1',
      '0',
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '3',
      '4',
      '1',
      '3',
      '1',
      '0',
      NULL,
      '4',
      NULL,
      '1',
      NULL,
      '0',
      '1',
      '0',
      NULL,
      NULL,
      '2',
      NULL,
      '0',
      '1',
      NULL,
      '2',
      '1',
      '4',
      '3',
      '1',
      NULL,
      '120',
      '33011142',
      60,
      46,
      NULL,
      2.400381,
      NULL,
      3,
      NULL,
      '201014',
      1.318046,
      ' 9-16-1991',
      ' 5-14-1995',
      8,
      25.671059,
      7.672168,
      12.357475,
      NULL,
      5.392557,
      0.719387,
      17.208136,
      0.097451,
      4.128028,
      NULL,
      0.686283,
      12.988125,
      23,
      16,
      16.885082,
      NULL,
      1.091007,
      7.080239,
      NULL,
      NULL,
      9.749048,
      6.643744,
      11,
      0,
      95,
      118,
      70,
      137.080862,
      235.616006,
      100.312009,
      ' 1-27-1995',
      NULL,
      18,
      1.696385,
      1,
      230,
      71,
      ' 6- 2-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      99.245196,
      13,
      4,
      10,
      NULL,
      3,
      '11- 8-1984',
      0,
      0,
      65.429529,
      NULL,
      1.353501,
      3,
      1.276246,
      0,
      68.864520,
      NULL,
      NULL,
      NULL,
      ' 1-17-1986',
      NULL,
      34,
      54.313926,
      87.278806,
      24,
      55.354123,
      NULL,
      13.623735,
      57.459049,
      NULL,
      87.722632,
      43.428259,
      NULL,
      16,
      17.136623,
      3,
      NULL,
      12,
      10,
      10.938819,
      '11-12-1990',
      10,
      15,
      '11- 0-1987',
      3,
      3,
      NULL,
      5.717668,
      19,
      NULL,
      0,
      2,
      1.376396,
      39,
      3,
      0,
      5.346487,
      0,
      1.742304,
      3.841285,
      0,
      NULL,
      ' 9-13-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      5.324473,
      ' 8-21-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.181294,
      ' 2-29-1997',
      4.737197,
      NULL,
      ' 9- 5-1999',
      157,
      144,
      ' 5- 7-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      ' 0-10-1979',
      28.098905,
      8.808184,
      23,
      '11-20-1988',
      0.513762,
      77,
      NULL,
      4.419972,
      75,
      10.428496,
      7,
      ' 3-13-1979',
      19.056598,
      1,
      2,
      ' 0-16-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


