set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8530746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3331',
      '30124020',
      '23440100',
      '33223400',
      NULL,
      '44413000',
      '11142240',
      '12041213',
      '11102431',
      '33023131',
      '13231110',
      '02320211',
      '21020304',
      '21324020',
      NULL,
      '34331140',
      '40002124',
      '33401423',
      NULL,
      '10344104',
      '23200130',
      NULL,
      '02114240',
      '43331432',
      '03120123',
      NULL,
      NULL,
      '33332400',
      '20313313',
      '01131231',
      '43330202',
      '40042134',
      '23314041',
      '03022200',
      NULL,
      '11331301',
      '14301424',
      NULL,
      '14003334',
      '24410302',
      NULL,
      '33104222',
      NULL,
      '41412334',
      '30334141',
      '131',
      '14',
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      1,
      NULL,
      NULL,
      2.963870,
      ' 4-12-1978',
      ' 5-18-2002',
      58.724513,
      NULL,
      8,
      5,
      18,
      14,
      NULL,
      23.713616,
      13.974348,
      NULL,
      48.858659,
      NULL,
      NULL,
      5,
      32.040918,
      23.204196,
      29.613860,
      5.558294,
      25,
      8.567249,
      NULL,
      NULL,
      18,
      0.150524,
      3.442644,
      77,
      5.161770,
      14.660645,
      29.892781,
      NULL,
      NULL,
      ' 7-28-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      6.818235,
      1.166249,
      9.422132,
      4,
      NULL,
      NULL,
      1,
      1.865585,
      2,
      1,
      NULL,
      1,
      1,
      1.620837,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 1-1975',
      9,
      31,
      18.425721,
      13,
      10,
      NULL,
      ' 7-29-1989',
      NULL,
      NULL,
      25,
      NULL,
      3.147904,
      1.973831,
      2,
      0.776773,
      15,
      7.566812,
      NULL,
      79.322097,
      '10-23-1983',
      8.193977,
      39,
      NULL,
      109.519883,
      NULL,
      24.066807,
      90,
      75,
      40.559565,
      24.906700,
      33,
      19,
      ' 1- 5-1983',
      2.966203,
      8.453219,
      1,
      NULL,
      25,
      3.310537,
      4.794737,
      NULL,
      NULL,
      6.198531,
      '10-29-1986',
      3.201521,
      4.669406,
      3,
      NULL,
      3,
      8.739912,
      1,
      9,
      1,
      13,
      0.150627,
      0,
      4.085500,
      NULL,
      4,
      2.785927,
      NULL,
      1.162984,
      ' 9-14-1989',
      3,
      0.493058,
      2.891128,
      '10-27-1982',
      39.959795,
      16,
      ' 5-24-1983',
      NULL,
      NULL,
      NULL,
      10.259961,
      '10-20-1986',
      46,
      ' 0-19-1998',
      20.672110,
      10,
      ' 4- 8-1997',
      NULL,
      8,
      ' 3-24-1982',
      4,
      3.292834,
      NULL,
      2,
      6.774737,
      ' 9-11-1981',
      2,
      0,
      18,
      ' 4- 5-1975',
      NULL,
      16,
      1.681484,
      ' 3-14-1981',
      1.720599,
      71,
      ' 3-12-1994',
      NULL,
      91,
      NULL,
      1,
      ' 3-22-1994',
      1,
      1.746043,
      35.728922,
      ' 7- 4-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


