set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8530746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1243',
      '20400232',
      NULL,
      '00130224',
      '12431042',
      '21204444',
      '11212233',
      '02420300',
      NULL,
      '01043232',
      '42322240',
      NULL,
      '11041130',
      NULL,
      '03131320',
      '24343144',
      '22422124',
      '33043410',
      '34404104',
      '44240223',
      NULL,
      '24223112',
      '02403243',
      NULL,
      NULL,
      '21142340',
      '23133430',
      '22402402',
      '14321440',
      '11040330',
      '12030410',
      '24020134',
      '43114043',
      '13324203',
      '01334111',
      '32120141',
      NULL,
      '13020133',
      '20401144',
      '14003000',
      '41304032',
      '40421202',
      NULL,
      '40400304',
      '00033022',
      '242',
      NULL,
      NULL,
      NULL,
      '1214122',
      1.174721,
      1.783247,
      0,
      NULL,
      '034433',
      0,
      ' 6-15-1983',
      ' 9-23-2000',
      56.186983,
      NULL,
      15,
      2,
      11.400095,
      12,
      NULL,
      14,
      8,
      NULL,
      16.224777,
      NULL,
      37.928810,
      0,
      36,
      NULL,
      9,
      3.184711,
      4.642112,
      17.223116,
      15,
      5.071844,
      NULL,
      7.571581,
      NULL,
      21.489265,
      51,
      13,
      NULL,
      169.148041,
      125.830524,
      ' 1- 3-1978',
      33.556789,
      7.959013,
      NULL,
      15,
      NULL,
      54,
      ' 1- 4-1996',
      6,
      0.688844,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-13-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-22-1994',
      NULL,
      20,
      NULL,
      NULL,
      NULL,
      29,
      68,
      5.962430,
      55.589902,
      49.812186,
      NULL,
      NULL,
      ' 5-10-1976',
      NULL,
      5.542745,
      0.061618,
      2,
      31,
      1.207475,
      5.230851,
      ' 6- 5-1983',
      7,
      3.609406,
      ' 1-25-2000',
      4.023796,
      NULL,
      14.541862,
      5,
      0,
      1.130400,
      0,
      3,
      1.510049,
      1.328434,
      0,
      0,
      6.935425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 3-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21.926760,
      NULL,
      4.577440,
      ' 3-20-1977',
      2,
      NULL,
      ' 7-29-1994',
      11.197868,
      118.629275,
      12,
      73,
      ' 4- 2-1999',
      44.053073,
      NULL,
      52.500627,
      ' 7- 0-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      56.167598,
      10,
      NULL,
      8.312887,
      2,
      8,
      NULL,
      6.808683,
      5.727358,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      190.816496,
      1,
      NULL,
      133.050387,
      NULL,
      24,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.040866,
      1,
      5.097785,
      0,
      NULL,
      1,
      4.905904,
      1.239683,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.677362,
      0.006604,
      23,
      NULL,
      NULL,
      2.577048,
      NULL,
      NULL,
      1.194007,
      2,
      7,
      3,
      0.805924,
      0.955912,
      2.756888,
      NULL,
      ' 0- 7-1999',
      NULL,
      ' 2-23-1985',
      ' 0- 3-1996',
      ' 9-10-1998',
      '11-25-1982',
      '10-14-1978',
      NULL);
commit;
end;
/


